/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.performlist;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.enquiry.api.performlist.bo.UpdateQuotationBillWithdrawReqBO;
import com.tydic.enquiry.api.performlist.bo.UpdateQuotationBillWithdrawRspBO;
import com.tydic.enquiry.api.performlist.service.UpdateQuotationBillWithdrawService;
import com.tydic.enquiry.api.sequence.bo.SeqEnquiryReqBO;
import com.tydic.enquiry.api.sequence.bo.SeqEnquiryRspBO;
import com.tydic.enquiry.api.sequence.service.SeqIdCreateService;
import com.tydic.enquiry.constant.Constants;
import com.tydic.enquiry.dao.DIqrInquiryDetailMapper;
import com.tydic.enquiry.dao.DIqrInquiryMateItemMapper;
import com.tydic.enquiry.dao.DIqrInquiryMateMapper;
import com.tydic.enquiry.dao.DIqrQuotationItemMapper;
import com.tydic.enquiry.dao.DIqrQuotationMapper;
import com.tydic.enquiry.dao.DIqrQuotationPkgMapper;
import com.tydic.enquiry.dao.DIqrRegistDetailMapper;
import com.tydic.enquiry.dao.DIqrRegistDocMapper;
import com.tydic.enquiry.po.DIqrInquiryDetailPO;
import com.tydic.enquiry.po.DIqrInquiryMatePO;
import com.tydic.enquiry.po.DIqrQuotationItemPO;
import com.tydic.enquiry.po.DIqrQuotationPO;
import com.tydic.enquiry.po.DIqrQuotationPkgPO;
import com.tydic.enquiry.po.DIqrRegistDetailPO;
import com.tydic.enquiry.po.DIqrRegistDocPO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="ENQUIRY_GROUP_TEST", serviceInterface=UpdateQuotationBillWithdrawService.class)
public class UpdateQuotationBillWithdrawServiceImpl
implements UpdateQuotationBillWithdrawService {
    private static final Logger log = LoggerFactory.getLogger(UpdateQuotationBillWithdrawServiceImpl.class);
    @Autowired
    private DIqrInquiryMateMapper dIqrInquiryMateMapper;
    @Autowired
    private DIqrInquiryMateItemMapper dIqrInquiryMateItemMapper;
    @Autowired
    private DIqrQuotationMapper dIqrQuotationMapper;
    @Autowired
    private DIqrQuotationItemMapper dIqrQuotationItemMapper;
    @Autowired
    private DIqrInquiryDetailMapper dIqrInquiryDetailMapper;
    @Autowired
    private DIqrQuotationPkgMapper dIqrQuotationPkgMapper;
    @Autowired
    private DIqrRegistDocMapper dIqrRegistDocMapper;
    @Autowired
    private DIqrRegistDetailMapper dIqrRegistDetailMapper;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="ENQUIRY_GROUP_TEST")
    private SeqIdCreateService seqIdCreateService;

    public UpdateQuotationBillWithdrawRspBO updateQuotationBillWithdraw(UpdateQuotationBillWithdrawReqBO reqBO) {
        UpdateQuotationBillWithdrawRspBO rspBO = new UpdateQuotationBillWithdrawRspBO();
        if (reqBO.getQuotationId() == null) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u5165\u53c2\u62a5\u4ef7\u5355ID\u4e0d\u53ef\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        try {
            DIqrQuotationPO quotationPO = this.dIqrQuotationMapper.selectByPrimaryKey(reqBO.getQuotationId());
            if (quotationPO.getSupplierId() == null || quotationPO.getSupplierId().longValue() != reqBO.getSupplierId().longValue()) {
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u6b64\u4f9b\u5e94\u5546\u4e0d\u5b58\u5728\u6b64\u62a5\u4ef7\u5355\uff01");
                return rspBO;
            }
            Date quoteEndDate = quotationPO.getQuoteEndDate();
            Date nowDate = new Date();
            log.error("nowDate.before(quoteEndDate) === " + quoteEndDate.before(nowDate) + "       " + DateUtils.dateToStr((Date)quoteEndDate, (String)"yyyy-MM-dd HH:mm:ss"));
            log.error("Constants.QUOTATION_DOC_STATUS_4002.equals(quotationPO.getDocStatus())=== " + "4002".equals(quotationPO.getDocStatus()));
            if (quoteEndDate.before(nowDate) || !"4002".equals(quotationPO.getDocStatus().toString())) {
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u62a5\u4ef7\u65f6\u95f4\u622a\u6b62\u5df2\u8fc7\uff0c\u4f9b\u5e94\u5546\u4e0d\u53ef\u4e3b\u52a8\u64a4\u56de\u62a5\u4ef7\uff01");
                return rspBO;
            }
            DIqrQuotationPO chngPO = new DIqrQuotationPO();
            chngPO.setDocStatus(Integer.parseInt("4003"));
            chngPO.setNodeStatus(Integer.parseInt("4103"));
            chngPO.setHisStatus("2");
            chngPO.setValidStatus(Constants.IS_VALID_N);
            chngPO.setQuotationId(reqBO.getQuotationId());
            this.dIqrQuotationMapper.updateByPrimaryKeySelective(chngPO);
            DIqrQuotationPkgPO chngPkgPO = new DIqrQuotationPkgPO();
            chngPkgPO.setQuotationId(reqBO.getQuotationId());
            chngPkgPO.setHisStatus("2");
            chngPkgPO.setDocStatus(Integer.parseInt("444001"));
            chngPkgPO.setNodeStatus(Integer.parseInt("444101"));
            this.dIqrQuotationPkgMapper.updateByQuotationId(chngPkgPO);
            DIqrRegistDocPO registDocPO = null;
            List<DIqrRegistDetailPO> registDetailPOS = null;
            Long newQuoteId = null;
            if (quotationPO.getLastRoundQuotationId() == null) {
                registDocPO = this.dIqrRegistDocMapper.selectRegistDocByInquiryIdSupId(quotationPO.getInquiryId(), reqBO.getSupplierId());
                if (registDocPO == null) {
                    rspBO.setRespCode("9999");
                    rspBO.setRespDesc("\u8be5\u6267\u884c\u5355\u65e0\u6b64\u4f9b\u5e94\u5546\u62a5\u540d\u4fe1\u606f\uff01");
                    return rspBO;
                }
                registDetailPOS = this.dIqrRegistDetailMapper.selectByRegistId(registDocPO.getRegistId());
                if (CollectionUtils.isEmpty(registDetailPOS)) {
                    rspBO.setRespCode("9999");
                    rspBO.setRespDesc("\u8be5\u6267\u884c\u5355\u65e0\u6b64\u4f9b\u5e94\u5546\u62a5\u540d\u660e\u7ec6\u4fe1\u606f\uff01");
                    return rspBO;
                }
                DIqrInquiryMatePO inquiryMatePO = this.dIqrInquiryMateMapper.selectValidByInquiryId(quotationPO.getInquiryId());
                List<DIqrInquiryDetailPO> inquiryDetailPOList = this.dIqrInquiryDetailMapper.selectByInquiryId(quotationPO.getInquiryId());
                newQuoteId = this.createQuoteWithdraw(inquiryMatePO, inquiryDetailPOList, registDocPO, registDetailPOS);
                log.error("newQuoteId:" + newQuoteId);
            } else {
                newQuoteId = quotationPO.getLastRoundQuotationId();
                DIqrQuotationPO lastPO = new DIqrQuotationPO();
                lastPO.setDocStatus(Integer.parseInt("4002"));
                lastPO.setNodeStatus(Integer.parseInt("4102"));
                lastPO.setHisStatus("1");
                lastPO.setValidStatus(Constants.IS_VALID_Y);
                lastPO.setQuotationId(newQuoteId);
                this.dIqrQuotationMapper.updateByPrimaryKeySelective(lastPO);
            }
            List<DIqrQuotationPO> quotationPOList = this.dIqrQuotationMapper.selectByInquiryIdDocStatus(quotationPO.getInquiryId(), "4002");
            if (!CollectionUtils.isEmpty(quotationPOList)) {
                StringBuffer idsJson = new StringBuffer();
                int cnt = 0;
                for (DIqrQuotationPO quote : quotationPOList) {
                    idsJson.append(quote.getQuotationId()).append(",");
                    ++cnt;
                }
                String quotationIdsJson = idsJson.toString();
                log.error("idsJson==" + quotationIdsJson);
                DIqrInquiryMatePO iqrInquiryMatePO = new DIqrInquiryMatePO();
                iqrInquiryMatePO.setInquiryId(quotationPO.getInquiryId());
                iqrInquiryMatePO.setQuotationIdsJson(quotationIdsJson.substring(0, quotationIdsJson.length() - 1));
                iqrInquiryMatePO.setQuotationNum(cnt);
                this.dIqrInquiryMateMapper.updateByInquiryId(iqrInquiryMatePO);
            }
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u64a4\u56de\u6210\u529f\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u64a4\u56de\u5931\u8d25\uff01");
        }
        return rspBO;
    }

    private Long createQuoteWithdraw(DIqrInquiryMatePO inquiryMatePO, List<DIqrInquiryDetailPO> inquiryDetailPOList, DIqrRegistDocPO registDocPO, List<DIqrRegistDetailPO> registDetailPOS) {
        DIqrQuotationPO dIqrQuotationPO = new DIqrQuotationPO();
        BeanUtils.copyProperties((Object)inquiryMatePO, (Object)dIqrQuotationPO);
        BeanUtils.copyProperties((Object)registDocPO, (Object)dIqrQuotationPO);
        SeqEnquiryReqBO seqEnquiryReqBO = new SeqEnquiryReqBO();
        seqEnquiryReqBO.setSystemId("ZH01");
        seqEnquiryReqBO.setSeqType("4");
        SeqEnquiryRspBO seqEnquiryPubRspBO = this.seqIdCreateService.getSeqId(seqEnquiryReqBO);
        Long quotationId = seqEnquiryPubRspBO.getDocId();
        dIqrQuotationPO.setQuotationId(quotationId);
        dIqrQuotationPO.setHisStatus("1");
        dIqrQuotationPO.setValidStatus(Constants.IS_VALID_Y);
        dIqrQuotationPO.setDocStatus(Integer.valueOf("4101"));
        dIqrQuotationPO.setQuoteRounds("0");
        this.dIqrQuotationMapper.insertSelective(dIqrQuotationPO);
        List<Object> record = new ArrayList();
        record = inquiryMatePO.getQuoteMethod() == Integer.parseInt("1") ? inquiryDetailPOList.stream().map(e -> {
            DIqrQuotationItemPO dIqrQuotationItemPO = new DIqrQuotationItemPO();
            BeanUtils.copyProperties((Object)e, (Object)dIqrQuotationItemPO);
            return dIqrQuotationItemPO;
        }).collect(Collectors.toList()) : registDetailPOS.stream().map(e -> {
            DIqrQuotationItemPO dIqrQuotationItemPO = new DIqrQuotationItemPO();
            for (DIqrInquiryDetailPO quoteInquiryDatailBO : inquiryDetailPOList) {
                if (quoteInquiryDatailBO.getInquiryItemId().longValue() != e.getInquiryItemId().longValue()) continue;
                BeanUtils.copyProperties((Object)quoteInquiryDatailBO, (Object)dIqrQuotationItemPO);
                break;
            }
            BeanUtils.copyProperties((Object)e, (Object)dIqrQuotationItemPO);
            dIqrQuotationItemPO.setQuotationId(quotationId);
            return dIqrQuotationItemPO;
        }).collect(Collectors.toList());
        this.dIqrQuotationItemMapper.insertBatch(record);
        if (inquiryMatePO.getDocType().equals("23")) {
            ArrayList<DIqrQuotationPkgPO> iqrQuotationPkgList = new ArrayList<DIqrQuotationPkgPO>();
            ArrayList<String> inquiryPkgIdList = new ArrayList<String>();
            for (DIqrRegistDetailPO quoteRegistItemBO : registDetailPOS) {
                DIqrQuotationPkgPO dIqrQuotationPkgPO = new DIqrQuotationPkgPO();
                if (iqrQuotationPkgList.size() <= 0) {
                    dIqrQuotationPkgPO.setQuotationId(quotationId);
                    dIqrQuotationPkgPO.setInquiryPkgId(quoteRegistItemBO.getInquiryPkgId());
                    dIqrQuotationPkgPO.setInquiryId(quoteRegistItemBO.getInquiryId());
                    dIqrQuotationPkgPO.setHisStatus("1");
                    dIqrQuotationPkgPO.setValidStatus(Constants.IS_VALID_Y);
                    dIqrQuotationPkgPO.setDocStatus(Integer.valueOf("4101"));
                    dIqrQuotationPkgPO.setQuoteRounds("0");
                    iqrQuotationPkgList.add(dIqrQuotationPkgPO);
                    inquiryPkgIdList.add(quoteRegistItemBO.getInquiryPkgId());
                    continue;
                }
                if (inquiryPkgIdList.contains(quoteRegistItemBO.getInquiryPkgId())) continue;
                dIqrQuotationPkgPO.setQuotationId(quotationId);
                dIqrQuotationPkgPO.setInquiryPkgId(quoteRegistItemBO.getInquiryPkgId());
                dIqrQuotationPkgPO.setInquiryId(quoteRegistItemBO.getInquiryId());
                dIqrQuotationPkgPO.setHisStatus("1");
                dIqrQuotationPkgPO.setValidStatus(Constants.IS_VALID_Y);
                dIqrQuotationPkgPO.setDocStatus(Integer.valueOf("4101"));
                dIqrQuotationPkgPO.setQuoteRounds("0");
                iqrQuotationPkgList.add(dIqrQuotationPkgPO);
                inquiryPkgIdList.add(quoteRegistItemBO.getInquiryPkgId());
            }
            this.dIqrQuotationPkgMapper.insertBatch(iqrQuotationPkgList);
        }
        return quotationId;
    }
}

