/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.distance;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.enquiry.api.distance.DistanceService;
import com.tydic.enquiry.api.distance.bo.DistanceRspBO;
import com.tydic.enquiry.api.distance.bo.QryDistanceInfoReqBO;
import com.tydic.enquiry.dao.SDistanceMapper;
import com.tydic.enquiry.po.SDistancePO;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="ENQUIRY_GROUP_TEST", serviceInterface=DistanceService.class)
public class DistanceServiceImpl
implements DistanceService {
    private static final Logger log = LoggerFactory.getLogger(DistanceServiceImpl.class);
    @Resource
    private SDistanceMapper sDistanceMapper;
    private Sequence sequence = Sequence.getInstance();

    private DistanceRspBO initParam(QryDistanceInfoReqBO infoReqBO) {
        DistanceRspBO rspBO = new DistanceRspBO();
        rspBO.setRespCode("0000");
        if (null == infoReqBO.getProvinceId()) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u7701");
        }
        if (null == infoReqBO.getCityId()) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u5e02");
        }
        if (null == infoReqBO.getAreaId()) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u533a");
        }
        if (null == infoReqBO.getAddrDesc()) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u8be6\u7ec6\u5730\u5740");
        }
        if (null == infoReqBO.getDistance()) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u8fd0\u8ddd");
        }
        if (null == infoReqBO.getOrgIdWeb()) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u7ec4\u7ec7\u673a\u6784ID");
        }
        if (null == infoReqBO.getOrgNameWeb()) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u7ec4\u7ec7\u673a\u6784\u540d\u79f0");
        }
        return rspBO;
    }

    public DistanceRspBO saveDistance(QryDistanceInfoReqBO qryDistanceInfoReqBO) {
        log.info("\u5165\u53c2\u6570\u636e\u4fe1\u606f\uff1aQryDistanceInfoReqBO=" + qryDistanceInfoReqBO.toString());
        DistanceRspBO rspBO = new DistanceRspBO();
        try {
            DistanceRspBO initParamRsqBO = this.initParam(qryDistanceInfoReqBO);
            if (!"0000".equals(initParamRsqBO.getRespCode())) {
                rspBO.setRespCode(initParamRsqBO.getRespCode());
                rspBO.setRespDesc(initParamRsqBO.getRespDesc() + ",\u4e0d\u80fd\u4e3a\u7a7a");
                return rspBO;
            }
            SDistancePO sDistancePO = new SDistancePO();
            sDistancePO.setOrgId(qryDistanceInfoReqBO.getOrgIdWeb());
            sDistancePO.setAreaId(qryDistanceInfoReqBO.getAreaId());
            SDistancePO modelBy = this.sDistanceMapper.getModelBy(sDistancePO);
            if (modelBy != null) {
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u8fd0\u8ddd\u5df2\u5b58\u5728!");
                return rspBO;
            }
            BeanUtils.copyProperties((Object)qryDistanceInfoReqBO, (Object)sDistancePO);
            sDistancePO.setDistanceId(this.sequence.nextId());
            sDistancePO.setCreatTime(new Date());
            sDistancePO.setUpdateTime(sDistancePO.getCreatTime());
            sDistancePO.setCreatorId(qryDistanceInfoReqBO.getUserId());
            sDistancePO.setCreatorName(qryDistanceInfoReqBO.getName());
            sDistancePO.setOrgName(qryDistanceInfoReqBO.getOrgName());
            sDistancePO.setOrgId(qryDistanceInfoReqBO.getOrgIdWeb());
            sDistancePO.setOrgName(qryDistanceInfoReqBO.getOrgNameWeb());
            int n = this.sDistanceMapper.insertBy(sDistancePO);
        }
        catch (Exception e) {
            log.error("\u65b0\u589e\u5931\u8d25\uff1a", (Throwable)e);
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u5931\u8d25\uff01" + e.getMessage());
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public DistanceRspBO updateDistanceInfoById(QryDistanceInfoReqBO qryDistanceInfoReqBO) {
        DistanceRspBO rspBO = new DistanceRspBO();
        try {
            if (null == qryDistanceInfoReqBO.getDistanceId()) {
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
                return rspBO;
            }
            SDistancePO sMaterailSet = new SDistancePO();
            sMaterailSet.setDistance(qryDistanceInfoReqBO.getDistance());
            sMaterailSet.setUpdateTime(new Date());
            SDistancePO sMaterailWher = new SDistancePO();
            sMaterailWher.setDistanceId(qryDistanceInfoReqBO.getDistanceId());
            this.sDistanceMapper.updateBy(sMaterailSet, sMaterailWher);
        }
        catch (Exception e) {
            log.error("\u4fee\u6539\u5931\u8d25\uff1a", (Throwable)e);
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u5931\u8d25\uff01" + e.getMessage());
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public DistanceRspBO delDistanceInfoById(QryDistanceInfoReqBO qryDistanceInfoReqBO) {
        DistanceRspBO rspBO = new DistanceRspBO();
        try {
            if (null == qryDistanceInfoReqBO.getDistanceId()) {
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
                return rspBO;
            }
            SDistancePO sDistancePO = new SDistancePO();
            sDistancePO.setDistanceId(qryDistanceInfoReqBO.getDistanceId());
            this.sDistanceMapper.deleteBy(sDistancePO);
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u5931\u8d25\uff1a", (Throwable)e);
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u5931\u8d25\uff01" + e.getMessage());
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public static void main(String[] args) {
        System.out.println(JSON.toJSONString((Object)new SDistancePO(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
    }
}

