/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.quote;

import com.alibaba.fastjson.JSONArray;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.enquiry.api.quote.bo.QuotationAttachmentBO;
import com.tydic.enquiry.api.quote.bo.QuotationPackageBO;
import com.tydic.enquiry.api.quote.bo.SubmitQuotationBillReqBO;
import com.tydic.enquiry.api.quote.bo.SubmitQuotationBillRspBO;
import com.tydic.enquiry.api.quote.service.SubmitQuotationBillService;
import com.tydic.enquiry.api.sequence.bo.SeqEnquiryReqBO;
import com.tydic.enquiry.api.sequence.bo.SeqEnquiryRspBO;
import com.tydic.enquiry.api.sequence.service.SeqIdCreateService;
import com.tydic.enquiry.constant.Constants;
import com.tydic.enquiry.dao.DIqrInquiryMateMapper;
import com.tydic.enquiry.dao.DIqrQuotationAttachMapper;
import com.tydic.enquiry.dao.DIqrQuotationItemMapper;
import com.tydic.enquiry.dao.DIqrQuotationItemMidMapper;
import com.tydic.enquiry.dao.DIqrQuotationMapper;
import com.tydic.enquiry.dao.DIqrQuotationPkgMapper;
import com.tydic.enquiry.dao.DIqrRegistDocMapper;
import com.tydic.enquiry.po.DIqrInquiryMatePO;
import com.tydic.enquiry.po.DIqrQuotationAttachPO;
import com.tydic.enquiry.po.DIqrQuotationItemMidPO;
import com.tydic.enquiry.po.DIqrQuotationItemPO;
import com.tydic.enquiry.po.DIqrQuotationPO;
import com.tydic.enquiry.po.DIqrQuotationPkgPO;
import com.tydic.enquiry.po.DIqrRegistDocPO;
import com.tydic.enquiry.util.QuoteUtil;
import com.tydic.uac.exception.BusinessException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ENQUIRY_GROUP/1.0.0/com.tydic.enquiry.api.quote.service.SubmitQuotationBillService"})
public class SubmitQuotationBillServiceImpl
implements SubmitQuotationBillService {
    private static final Logger log = LoggerFactory.getLogger(SubmitQuotationBillServiceImpl.class);
    @Autowired
    private DIqrQuotationMapper dIqrQuotationMapper;
    @Autowired
    private DIqrQuotationItemMapper dIqrQuotationItemMapper;
    @Autowired
    private DIqrInquiryMateMapper dIqrInquiryMateMapper;
    @Autowired
    private DIqrQuotationPkgMapper dIqrQuotationPkgMapper;
    @Autowired
    private SeqIdCreateService seqIdCreateService;
    @Autowired
    private DIqrQuotationItemMidMapper dIqrQuotationItemMidMapper;
    @Autowired
    private DIqrQuotationAttachMapper dIqrQuotationAttachMapper;
    @Autowired
    private DIqrRegistDocMapper dIqrRegistDocMapper;

    @PostMapping(value={"submitQuotationBill"})
    public SubmitQuotationBillRspBO submitQuotationBill(@RequestBody SubmitQuotationBillReqBO submitQuotationBillReqBO) {
        log.info("\u62a5\u4ef7\u5355\u63d0\u4ea4\u5165\u53c2\uff1a" + submitQuotationBillReqBO.toString());
        SubmitQuotationBillRspBO rspBO = new SubmitQuotationBillRspBO();
        DIqrQuotationPO quotationPO = this.dIqrQuotationMapper.selectByPrimaryKey(submitQuotationBillReqBO.getQuotationId());
        if (quotationPO == null || quotationPO.getValidStatus() != Constants.IS_VALID_Y || quotationPO.getDocStatus() == null) {
            log.error("\u6b64\u62a5\u4ef7\u5355\u4e0d\u5b58\u5728\u6216\u5df2\u5931\u6548\u4e0d\u53ef\u7ee7\u7eed\u62a5\u4ef7");
            rspBO.setRespCode("9900");
            rspBO.setRespDesc("\u6b64\u62a5\u4ef7\u5355\u4e0d\u5b58\u5728\u6216\u5df2\u5931\u6548\u4e0d\u53ef\u7ee7\u7eed\u62a5\u4ef7");
            log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
            return rspBO;
        }
        DIqrInquiryMatePO dIqrInquiryMatePO = this.dIqrInquiryMateMapper.selectByInquiryId(quotationPO.getInquiryId());
        if (dIqrInquiryMatePO == null || dIqrInquiryMatePO.getDocType() == null) {
            log.error("\u5f53\u524d\u6267\u884c\u5355\u4e0d\u5b58\u5728\u4e0d\u53ef\u4ee5\u62a5\u4ef7");
            rspBO.setRespCode("9900");
            rspBO.setRespDesc("\u5f53\u524d\u6267\u884c\u5355\u4e0d\u5b58\u5728\u4e0d\u53ef\u4ee5\u62a5\u4ef7");
            log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
            return rspBO;
        }
        Date date0 = new Date();
        if (!dIqrInquiryMatePO.getDocStatus().toString().equals("2003") || date0.compareTo(dIqrInquiryMatePO.getQuoteEndDate()) >= 0 || date0.compareTo(dIqrInquiryMatePO.getLimitQuoteDate()) < 0) {
            log.error("\u5f53\u524d\u6267\u884c\u5355\u4e0d\u4e3a\u62a5\u4ef7\u4e2d\u6216\u5df2\u8fc7\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\u4e0d\u53ef\u4ee5\u62a5\u4ef7");
            rspBO.setRespCode("9900");
            rspBO.setRespDesc("\u5f53\u524d\u6267\u884c\u5355\u4e0d\u4e3a\u62a5\u4ef7\u4e2d\u6216\u5df2\u8fc7\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\u4e0d\u53ef\u4ee5\u62a5\u4ef7");
            log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
            return rspBO;
        }
        if ("21".equals(dIqrInquiryMatePO.getDocType()) && !quotationPO.getDocStatus().toString().equals("4001") || !quotationPO.getDocStatus().toString().equals("4001") && "22".equals(dIqrInquiryMatePO.getDocType()) && quotationPO.getQuoteRounds() != null && quotationPO.getQuoteTimeLimit() != null && Integer.valueOf(quotationPO.getQuoteRounds()) >= quotationPO.getQuoteTimeLimit()) {
            log.error("\u5f53\u524d\u62a5\u4ef7\u5df2\u63d0\u4ea4\u6216\u6b21\u6570\u5df2\u8fbe\u5230\u4e0a\u9650\u4e0d\u53ef\u518d\u6b21\u62a5\u4ef7");
            rspBO.setRespCode("9900");
            rspBO.setRespDesc("\u5f53\u524d\u5355\u636e\u8fd8\u672a\u5f00\u59cb\u4e0b\u4e00\u6b21\u62a5\u4ef7\u6216\u62a5\u4ef7\u6b21\u6570\u5df2\u8fbe\u5230\u4e0a\u9650\uff0c\u4e0d\u5141\u8bb8\u62a5\u4ef7");
            log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
            return rspBO;
        }
        if (submitQuotationBillReqBO.getRedisNo() == null) {
            log.error("RedisNo\u4e0d\u53ef\u4ee5\u4e3a\u7a7a");
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("RedisNo\u4e0d\u53ef\u4ee5\u4e3a\u7a7a");
            log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
            return rspBO;
        }
        if (!"23".equals(dIqrInquiryMatePO.getDocType()) && dIqrInquiryMatePO.getTotalPriceFlag() != null && "Y".equals(dIqrInquiryMatePO.getTotalPriceFlag()) && (submitQuotationBillReqBO.getAmount() == null || submitQuotationBillReqBO.getAmount().compareTo(BigDecimal.ZERO) <= 0)) {
            log.error("\u6574\u5355\u62a5\u4ef7\u4e3a\u53ea\u62a5\u603b\u4ef7\u65f6\u62a5\u4ef7\u91d1\u989d\u4e0d\u53ef\u4ee5\u4e3a\u7a7a");
            rspBO.setRespCode("9900");
            rspBO.setRespDesc("\u6574\u5355\u62a5\u4ef7\u4e3a\u53ea\u62a5\u603b\u4ef7\u65f6\u62a5\u4ef7\u91d1\u989d\u4e0d\u53ef\u4ee5\u4e3a\u7a7a");
            log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
            return rspBO;
        }
        if ("23".equals(dIqrInquiryMatePO.getDocType()) && (submitQuotationBillReqBO.getPackageList() == null || submitQuotationBillReqBO.getPackageList().size() <= 0)) {
            log.error("\u7ade\u4ef7\u5355\u62a5\u4ef7\u5355\u7ade\u4ef7\u62a5\u4ef7\u4fe1\u606f\u4e0d\u53ef\u4ee5\u4e3a\u7a7a\uff01\uff01\uff01");
            rspBO.setRespCode("9900");
            rspBO.setRespDesc("\u7ade\u4ef7\u5355\u62a5\u4ef7\u5355\u7ade\u4ef7\u62a5\u4ef7\u4fe1\u606f\u4e0d\u53ef\u4ee5\u4e3a\u7a7a\uff01\uff01\uff01");
            log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
            return rspBO;
        }
        if (dIqrInquiryMatePO.getTotalPriceFlag() != null && "Y".equals(dIqrInquiryMatePO.getTotalPriceFlag()) && "23".equals(dIqrInquiryMatePO.getDocType())) {
            BigDecimal quotationAmount = new BigDecimal("0");
            for (QuotationPackageBO quotationPackageBO : submitQuotationBillReqBO.getPackageList()) {
                if (quotationPackageBO.getAmount() == null) continue;
                quotationAmount = quotationAmount.add(quotationPackageBO.getAmount());
            }
            if (quotationAmount.compareTo(BigDecimal.ZERO) <= 0) {
                log.error("\u6574\u5355\u53ea\u62a5\u603b\u4ef7\u65f6\u7ade\u4ef7\u5355\u62a5\u4ef7\u5355\u603b\u62a5\u4ef7\u91d1\u989d\u4e0d\u53ef\u4ee5\u4e3a\u7a7a\uff01\uff01\uff01");
                rspBO.setRespCode("9900");
                rspBO.setRespDesc("\u6574\u5355\u53ea\u62a5\u603b\u4ef7\u65f6\u7ade\u4ef7\u5355\u62a5\u4ef7\u5355\u603b\u62a5\u4ef7\u91d1\u989d\u4e0d\u53ef\u4ee5\u4e3a\u7a7a\uff01\uff01\uff01");
                log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
                return rspBO;
            }
            submitQuotationBillReqBO.setAmount(quotationAmount);
        }
        DIqrQuotationItemPO quotationItemPO = new DIqrQuotationItemPO();
        quotationItemPO.setQuotationId(submitQuotationBillReqBO.getQuotationId());
        List<DIqrQuotationItemPO> quotationItemPOs = this.dIqrQuotationItemMapper.selectByQuotationItem(quotationItemPO);
        DIqrQuotationItemMidPO quotationItem = new DIqrQuotationItemMidPO();
        quotationItem.setQuotationId(submitQuotationBillReqBO.getQuotationId());
        quotationItem.setRedisNo(submitQuotationBillReqBO.getRedisNo());
        List<DIqrQuotationItemMidPO> dIqrQuotationItemMidPOList = this.dIqrQuotationItemMidMapper.selectByQuotationItem(quotationItem);
        rspBO = this.checkQuoteItem(dIqrInquiryMatePO.getBusiType(), dIqrInquiryMatePO.getTotalPriceFlag(), dIqrInquiryMatePO.getDocType(), dIqrInquiryMatePO.getQuoteMethod(), dIqrQuotationItemMidPOList, quotationItemPOs);
        if (!"0000".equals(rspBO.getRespCode())) {
            log.error("\u62a5\u4ef7\u660e\u7ec6\u6821\u9a8c\u5931\u8d25\uff1a" + rspBO.getRespDesc());
            log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
            return rspBO;
        }
        ArrayList<DIqrQuotationItemPO> dIqrQuotationItemPOs = new ArrayList<DIqrQuotationItemPO>();
        for (DIqrQuotationItemMidPO dIqrQuotationItemMidPO : dIqrQuotationItemMidPOList) {
            DIqrQuotationItemPO dIqrQuotationItemPO = new DIqrQuotationItemPO();
            BeanUtils.copyProperties((Object)dIqrQuotationItemMidPO, (Object)dIqrQuotationItemPO);
            dIqrQuotationItemPOs.add(dIqrQuotationItemPO);
        }
        DIqrQuotationPO qryQuotationPO = new DIqrQuotationPO();
        ArrayList<Integer> docStatusList = new ArrayList<Integer>();
        docStatusList.add(Integer.valueOf("4002"));
        docStatusList.add(Integer.valueOf("4004"));
        docStatusList.add(Integer.valueOf("4006"));
        qryQuotationPO.setInquiryId(quotationPO.getInquiryId());
        qryQuotationPO.setValidStatus(Constants.IS_VALID_Y);
        qryQuotationPO.setHisStatus("1");
        qryQuotationPO.setDocStatusList(docStatusList);
        if (!"23".equals(dIqrInquiryMatePO.getDocType()) || dIqrInquiryMatePO.getComparedQuoteType() != null && "3".equals(dIqrInquiryMatePO.getComparedQuoteType())) {
            qryQuotationPO.setQuotationId(submitQuotationBillReqBO.getQuotationId());
        }
        List<DIqrQuotationPO> effectiveQuotationPOList = this.dIqrQuotationMapper.selectQuotationByPrimary(qryQuotationPO);
        BigDecimal mostQuotationItemQrice = new BigDecimal("0");
        if ("1".equals(dIqrInquiryMatePO.getQuoteMethod().toString()) && CollectionUtils.isNotEmpty(effectiveQuotationPOList)) {
            Long quoteAmount = effectiveQuotationPOList.get(0).getAmount();
            if (StringUtils.isNotEmpty((CharSequence)effectiveQuotationPOList.get(0).getAmountSec())) {
                quoteAmount = QuoteUtil.decode(effectiveQuotationPOList.get(0).getAmountSec(), effectiveQuotationPOList.get(0).getQuotationId().toString());
            }
            try {
                mostQuotationItemQrice = MoneyUtils.Long2BigDecimal((Long)quoteAmount);
                for (DIqrQuotationPO dIqrQuotationPO : effectiveQuotationPOList) {
                    Long amount = dIqrQuotationPO.getAmount();
                    if (StringUtils.isNotEmpty((CharSequence)dIqrQuotationPO.getAmountSec())) {
                        amount = QuoteUtil.decode(dIqrQuotationPO.getAmountSec(), dIqrQuotationPO.getQuotationId().toString());
                    }
                    if ("2".contains(dIqrInquiryMatePO.getBusiType()) && mostQuotationItemQrice.compareTo(MoneyUtils.Long2BigDecimal((Long)amount)) < 0) {
                        mostQuotationItemQrice = MoneyUtils.Long2BigDecimal((Long)amount);
                        continue;
                    }
                    if ("2".contains(dIqrInquiryMatePO.getBusiType()) || mostQuotationItemQrice.compareTo(MoneyUtils.Long2BigDecimal((Long)amount)) <= 0) continue;
                    mostQuotationItemQrice = MoneyUtils.Long2BigDecimal((Long)amount);
                }
            }
            catch (Exception e2) {
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u91d1\u989d\u8f6c\u5316\u5f02\u5e38");
                log.error("\u91d1\u989d\u8f6c\u5316\u6216\u8ba1\u7b97\u5f02\u5e38," + e2);
                throw new BusinessException("9999", "\u91d1\u989d\u8f6c\u5316\u6216\u8ba1\u7b97\u5f02\u5e38", (Throwable)e2);
            }
            if ("23".equals(dIqrInquiryMatePO.getDocType()) && StringUtils.isNotEmpty((CharSequence)dIqrInquiryMatePO.getOfferIncreaseValue())) {
                BigDecimal hundred = new BigDecimal("100");
                BigDecimal proportion = new BigDecimal(dIqrInquiryMatePO.getOfferIncreaseValue()).divide(hundred);
                BigDecimal price = new BigDecimal(dIqrInquiryMatePO.getOfferIncreaseValue());
                if ("2".equals(dIqrInquiryMatePO.getBusiType()) && "1".equals(dIqrInquiryMatePO.getOfferIncreaseType())) {
                    mostQuotationItemQrice = mostQuotationItemQrice.multiply(proportion.add(new BigDecimal("1"))).setScale(2, 4);
                } else if ("2".equals(dIqrInquiryMatePO.getBusiType()) && "2".equals(dIqrInquiryMatePO.getOfferIncreaseType())) {
                    mostQuotationItemQrice = mostQuotationItemQrice.add(price);
                } else if (!"2".equals(dIqrInquiryMatePO.getBusiType()) && "1".equals(dIqrInquiryMatePO.getOfferIncreaseType())) {
                    mostQuotationItemQrice = mostQuotationItemQrice.multiply(new BigDecimal("1").subtract(proportion)).setScale(2, 4);
                } else if (!"2".equals(dIqrInquiryMatePO.getBusiType()) && "2".equals(dIqrInquiryMatePO.getOfferIncreaseType())) {
                    mostQuotationItemQrice = mostQuotationItemQrice.subtract(price);
                }
            }
        }
        if (!"0000".equals((rspBO = "4001".equals(quotationPO.getDocStatus().toString()) ? this.updateQuotationBill(submitQuotationBillReqBO, dIqrInquiryMatePO.getDocType(), dIqrInquiryMatePO.getBusiType(), dIqrQuotationItemPOs, dIqrInquiryMatePO.getTotalPriceFlag(), quotationPO, mostQuotationItemQrice) : this.addQuotationBill(submitQuotationBillReqBO, dIqrInquiryMatePO.getDocType(), dIqrInquiryMatePO.getBusiType(), dIqrQuotationItemPOs, dIqrInquiryMatePO.getTotalPriceFlag(), quotationPO, mostQuotationItemQrice)).getRespCode())) {
            log.error("\u62a5\u4ef7\u5355\u63d0\u4ea4\u5931\u8d25\uff1a" + rspBO.getRespDesc());
            rspBO.setRespCode(rspBO.getRespCode());
            rspBO.setRespDesc("\u62a5\u4ef7\u5355\u63d0\u4ea4\u5931\u8d25\uff1a" + rspBO.getRespDesc());
            log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
            return rspBO;
        }
        try {
            DIqrQuotationPO record;
            Calendar nowTime = Calendar.getInstance();
            nowTime.add(12, 5);
            log.info("submitQuotationBill::nowTime::" + nowTime);
            log.info("submitQuotationBill::nowTime.getTime()::" + nowTime.getTime());
            log.info("submitQuotationBill::dIqrInquiryMatePO.getQuoteEndDate()::" + dIqrInquiryMatePO.getQuoteEndDate());
            log.info("submitQuotationBill::dIqrInquiryMatePO.getDocType()::" + dIqrInquiryMatePO.getDocType());
            log.info("submitQuotationBill::dIqrInquiryMatePO.getDelayBiddingFlag()::" + dIqrInquiryMatePO.getDelayBiddingFlag());
            if (dIqrInquiryMatePO.getDocType() != null && "23".equals(dIqrInquiryMatePO.getDocType()) && nowTime.getTime().after(dIqrInquiryMatePO.getQuoteEndDate()) && dIqrInquiryMatePO.getDelayBiddingFlag() != null && "Y".equals(dIqrInquiryMatePO.getDelayBiddingFlag())) {
                record = new DIqrQuotationPO();
                Date quoteEndDate = new Date(dIqrInquiryMatePO.getQuoteEndDate().getTime() + 300000L);
                log.info("submitQuotationBill::dIqrInquiryMatePO.getQuoteEndDate().getTime()::" + dIqrInquiryMatePO.getQuoteEndDate().getTime());
                log.info("submitQuotationBill::quoteEndDate::" + quoteEndDate);
                record.setQuoteEndDate(quoteEndDate);
                record.setInquiryId(quotationPO.getInquiryId());
                this.dIqrQuotationMapper.updateQuoteEndTimeByInquiryId(record);
                DIqrRegistDocPO registDoc = new DIqrRegistDocPO();
                registDoc.setQuoteEndDate(quoteEndDate);
                registDoc.setInquiryId(quotationPO.getInquiryId());
                this.dIqrRegistDocMapper.updateQuoteEndTimeByInquiryId(registDoc);
            }
            record = new DIqrQuotationPO();
            record.setInquiryId(submitQuotationBillReqBO.getInquiryId());
            record.setDocStatus(Integer.valueOf("4002"));
            record.setValidStatus(Constants.IS_VALID_Y);
            record.setHisStatus("1");
            List<DIqrQuotationPO> dIqrQuotationPOs = this.dIqrQuotationMapper.selectQuotationByPrimary(record);
            List<Object> quotationIds = new ArrayList();
            if (!CollectionUtils.isEmpty(dIqrQuotationPOs)) {
                quotationIds = dIqrQuotationPOs.stream().map(e -> e.getQuotationId()).collect(Collectors.toList());
            }
            DIqrInquiryMatePO updateInquiryMatePO = new DIqrInquiryMatePO();
            updateInquiryMatePO.setQuotationIdsJson(JSONArray.toJSONString(quotationIds));
            updateInquiryMatePO.setQuotationNum(quotationIds.size());
            updateInquiryMatePO.setInquiryId(submitQuotationBillReqBO.getInquiryId());
            if (dIqrInquiryMatePO.getDocType() != null && "23".equals(dIqrInquiryMatePO.getDocType()) && nowTime.getTime().after(dIqrInquiryMatePO.getQuoteEndDate()) && dIqrInquiryMatePO.getDelayBiddingFlag() != null && "Y".equals(dIqrInquiryMatePO.getDelayBiddingFlag())) {
                Date quoteEndDate = new Date(dIqrInquiryMatePO.getQuoteEndDate().getTime() + 300000L);
                updateInquiryMatePO.setQuoteEndDate(quoteEndDate);
                updateInquiryMatePO.setDelayLengthTime(dIqrInquiryMatePO.getDelayLengthTime() == null ? 5 : dIqrInquiryMatePO.getDelayLengthTime() + 5);
                updateInquiryMatePO.setDelayCnt(dIqrInquiryMatePO.getDelayCnt() == null ? 1 : dIqrInquiryMatePO.getDelayCnt() + 1);
            }
            this.dIqrInquiryMateMapper.updateByInquiryId(updateInquiryMatePO);
        }
        catch (Exception e3) {
            log.error("\u66f4\u65b0\u8be2\u4ef7\u5355\u62a5\u4ef7\u5bb6\u6570\u5931\u8d25:" + e3);
            throw new BusinessException("9999", "\u66f4\u65b0\u8be2\u4ef7\u5355\u62a5\u4ef7\u5bb6\u6570\u5931\u8d25:" + e3.getMessage());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u62a5\u4ef7\u5355\u63d0\u4ea4\u6210\u529f");
        log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
        return rspBO;
    }

    public SubmitQuotationBillRspBO updateQuotationBill(SubmitQuotationBillReqBO submitQuotationBillReqBO, String docType, String busiType, List<DIqrQuotationItemPO> dIqrQuotationItemPOs, String totalPriceFlag, DIqrQuotationPO quotationPO, BigDecimal mostQuotationItemQrice) {
        SubmitQuotationBillRspBO rspBO = new SubmitQuotationBillRspBO();
        DIqrQuotationPO updateQuotationPO = new DIqrQuotationPO();
        HashMap<String, Long> pkgQuoteAmountMap = new HashMap<String, Long>();
        Long quoteAmount = 0L;
        BigDecimal amount = new BigDecimal("0");
        if (!"Y".equals(totalPriceFlag)) {
            try {
                for (DIqrQuotationItemPO dIqrQuotationItemPO : dIqrQuotationItemPOs) {
                    if (dIqrQuotationItemPO.getQuotePrice() == null && StringUtils.isBlank((CharSequence)dIqrQuotationItemPO.getQuotePriceSec())) continue;
                    BigDecimal itemQuoteAmount = new BigDecimal("0");
                    Long quotePrice = dIqrQuotationItemPO.getQuotePrice();
                    if (StringUtils.isNotEmpty((CharSequence)dIqrQuotationItemPO.getQuotePriceSec())) {
                        quotePrice = QuoteUtil.decode(dIqrQuotationItemPO.getQuotePriceSec(), dIqrQuotationItemPO.getQuotationId().toString());
                    }
                    itemQuoteAmount = MoneyUtils.Long2BigDecimal((Long)quotePrice).multiply(MoneyUtils.Long2BigDecimal((Long)dIqrQuotationItemPO.getPurchaseNum())).setScale(2, 4);
                    quoteAmount = MoneyUtils.BigDecimal2Long((BigDecimal)itemQuoteAmount) + quoteAmount;
                    if (StringUtils.isNotBlank((CharSequence)dIqrQuotationItemPO.getInquiryPkgId()) && pkgQuoteAmountMap.size() <= 0) {
                        pkgQuoteAmountMap.put(dIqrQuotationItemPO.getInquiryPkgId(), MoneyUtils.BigDecimal2Long((BigDecimal)itemQuoteAmount));
                        continue;
                    }
                    if (StringUtils.isNotBlank((CharSequence)dIqrQuotationItemPO.getInquiryPkgId()) && pkgQuoteAmountMap.get(dIqrQuotationItemPO.getInquiryPkgId()) == null) {
                        pkgQuoteAmountMap.put(dIqrQuotationItemPO.getInquiryPkgId(), MoneyUtils.BigDecimal2Long((BigDecimal)itemQuoteAmount));
                        continue;
                    }
                    if (!StringUtils.isNotBlank((CharSequence)dIqrQuotationItemPO.getInquiryPkgId())) continue;
                    Long pkgQuoteAmount = (Long)pkgQuoteAmountMap.get(dIqrQuotationItemPO.getInquiryPkgId());
                    pkgQuoteAmount = pkgQuoteAmount + MoneyUtils.BigDecimal2Long((BigDecimal)itemQuoteAmount);
                    pkgQuoteAmountMap.put(dIqrQuotationItemPO.getInquiryPkgId(), pkgQuoteAmount);
                }
                updateQuotationPO.setAmount(0L);
                updateQuotationPO.setAmountSec(QuoteUtil.encode(quoteAmount, submitQuotationBillReqBO.getQuotationId().toString()));
                amount = MoneyUtils.Long2BigDecimal((Long)quoteAmount);
            }
            catch (Exception e) {
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u91d1\u989d\u8f6c\u5316\u5f02\u5e38");
                log.error("\u91d1\u989d\u8f6c\u5316\u6216\u8ba1\u7b97\u5f02\u5e38," + e);
                throw new BusinessException("9999", "\u91d1\u989d\u8f6c\u5316\u6216\u8ba1\u7b97\u5f02\u5e38", (Throwable)e);
            }
        }
        try {
            amount = submitQuotationBillReqBO.getAmount();
            updateQuotationPO.setAmount(0L);
            updateQuotationPO.setAmountSec(QuoteUtil.encode(MoneyUtils.BigDecimal2Long((BigDecimal)submitQuotationBillReqBO.getAmount()), submitQuotationBillReqBO.getQuotationId().toString()));
        }
        catch (Exception e) {
            log.error("\u91d1\u989d\u8f6c\u5316\u6216\u8ba1\u7b97\u5f02\u5e38", (Throwable)e);
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u91d1\u989d\u8f6c\u5316\u6216\u8ba1\u7b97\u5f02\u5e38");
            throw new BusinessException("9999", "\u66f4\u65b0\u62a5\u4ef7\u5355\u5931\u8d25\uff1a", (Throwable)e);
        }
        if ("23".equals(docType) && "2".equals(busiType) && mostQuotationItemQrice != null && mostQuotationItemQrice.compareTo(BigDecimal.ZERO) > 0 && amount.compareTo(mostQuotationItemQrice) < 0) {
            log.error("\u66f4\u65b0\u62a5\u4ef7\u5355\u5931\u8d25\uff1a\u62a5\u4ef7\u603b\u91d1\u989d\u4e0d\u53ef\u4ee5\u4f4e\u4e8e" + mostQuotationItemQrice);
            rspBO.setRespCode("9900");
            rspBO.setRespDesc("\u66f4\u65b0\u62a5\u4ef7\u5355\u5931\u8d25\uff1a\u62a5\u4ef7\u603b\u91d1\u989d\u4e0d\u53ef\u4ee5\u4f4e\u4e8e" + mostQuotationItemQrice);
            return rspBO;
        }
        if ("23".equals(docType) && !"2".equals(busiType) && mostQuotationItemQrice != null && mostQuotationItemQrice.compareTo(BigDecimal.ZERO) > 0 && amount.compareTo(mostQuotationItemQrice) > 0) {
            log.error("\u66f4\u65b0\u62a5\u4ef7\u5355\u5931\u8d25\uff1a\u62a5\u4ef7\u603b\u91d1\u989d\u4e0d\u53ef\u4ee5\u4f4e\u4e8e" + mostQuotationItemQrice);
            rspBO.setRespCode("9900");
            rspBO.setRespDesc("\u66f4\u65b0\u62a5\u4ef7\u5355\u5931\u8d25\uff1a\u62a5\u4ef7\u603b\u91d1\u989d\u4e0d\u53ef\u4ee5\u4f4e\u4e8e" + mostQuotationItemQrice);
            return rspBO;
        }
        if (!"23".equals(docType) && "2".equals(busiType) && mostQuotationItemQrice != null && mostQuotationItemQrice.compareTo(BigDecimal.ZERO) > 0 && amount.compareTo(mostQuotationItemQrice) <= 0) {
            log.error("\u66f4\u65b0\u62a5\u4ef7\u5355\u5931\u8d25\uff1a\u62a5\u4ef7\u603b\u91d1\u989d\u4e0d\u53ef\u4ee5\u4f4e\u4e8e" + mostQuotationItemQrice);
            rspBO.setRespCode("9900");
            rspBO.setRespDesc("\u66f4\u65b0\u62a5\u4ef7\u5355\u5931\u8d25\uff1a\u62a5\u4ef7\u603b\u91d1\u989d\u4e0d\u53ef\u4ee5\u4f4e\u4e8e" + mostQuotationItemQrice);
            return rspBO;
        }
        if (!"23".equals(docType) && !"2".equals(busiType) && mostQuotationItemQrice != null && mostQuotationItemQrice.compareTo(BigDecimal.ZERO) > 0 && amount.compareTo(mostQuotationItemQrice) >= 0) {
            log.error("\u66f4\u65b0\u62a5\u4ef7\u5355\u5931\u8d25\uff1a\u62a5\u4ef7\u603b\u91d1\u989d\u4e0d\u53ef\u4ee5\u4f4e\u4e8e" + mostQuotationItemQrice);
            rspBO.setRespCode("9900");
            rspBO.setRespDesc("\u66f4\u65b0\u62a5\u4ef7\u5355\u5931\u8d25\uff1a\u62a5\u4ef7\u603b\u91d1\u989d\u4e0d\u53ef\u4ee5\u4f4e\u4e8e" + mostQuotationItemQrice);
            return rspBO;
        }
        log.info("\u62a5\u4ef7\u5355\u8054\u7cfb\u4eba\u4e3a\uff1a" + submitQuotationBillReqBO.getSupplierContactName() + ";\u62a5\u4ef7\u5355\u8054\u7cfb\u65b9\u5f0f\u4e3a\uff1a" + submitQuotationBillReqBO.getSupplierContactTele());
        if (!"23".equals(docType)) {
            updateQuotationPO.setSupplierContactName(submitQuotationBillReqBO.getSupplierContactName());
            updateQuotationPO.setSupplierContactTele(submitQuotationBillReqBO.getSupplierContactTele());
            if (StringUtils.isNotBlank((CharSequence)submitQuotationBillReqBO.getDeliveryDatePromise()) && submitQuotationBillReqBO.getDeliveryDatePromise().length() == 10) {
                updateQuotationPO.setDeliveryDatePromise(DateUtils.strToDateLong((String)submitQuotationBillReqBO.getDeliveryDatePromise(), (String)"yyyy-MM-dd"));
            } else {
                updateQuotationPO.setDeliveryDatePromise(DateUtils.strToDateLong((String)submitQuotationBillReqBO.getDeliveryDatePromise(), (String)"yyyy-MM-dd HH:mm:ss"));
            }
        }
        updateQuotationPO.setDeliveryIntPromise(submitQuotationBillReqBO.getDeliveryIntPromise());
        updateQuotationPO.setQuoteExplain(submitQuotationBillReqBO.getQuoteExplain());
        updateQuotationPO.setQuotationSubmitTime(new Date());
        updateQuotationPO.setDocStatus(Integer.valueOf("4002"));
        updateQuotationPO.setNodeStatus(Integer.valueOf("4102"));
        updateQuotationPO.setQuotationId(submitQuotationBillReqBO.getQuotationId());
        updateQuotationPO.setQuoteIpAddr(submitQuotationBillReqBO.getQuoteIpAddr());
        if ("22".equals(docType) && quotationPO.getQuoteTimeLimit() != null) {
            updateQuotationPO.setQuoteRounds(quotationPO.getQuoteTimeLimit().toString());
        } else if (StringUtils.isNotEmpty((CharSequence)quotationPO.getQuoteRounds())) {
            Integer quoteRounds = Integer.valueOf(quotationPO.getQuoteRounds()) + 1;
            updateQuotationPO.setQuoteRounds(quoteRounds.toString());
        } else {
            updateQuotationPO.setQuoteRounds("1");
        }
        updateQuotationPO.setQuotationCreateUserId(submitQuotationBillReqBO.getUserId());
        updateQuotationPO.setQuotationCreateUserName(submitQuotationBillReqBO.getUsername());
        try {
            this.dIqrQuotationMapper.updateByPrimaryKeySelective(updateQuotationPO);
        }
        catch (Exception e) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u66f4\u65b0\u62a5\u4ef7\u5931\u8d25");
            log.error("\u66f4\u65b0\u62a5\u4ef7\u5355\u5931\u8d25\uff1a", (Throwable)e);
            throw new BusinessException("9999", "\u66f4\u65b0\u62a5\u4ef7\u5355\u5931\u8d25\uff1a", (Throwable)e);
        }
        if ("23".equals(docType)) {
            try {
                ArrayList<DIqrQuotationPkgPO> quotationPkgList = new ArrayList<DIqrQuotationPkgPO>();
                for (QuotationPackageBO quotationPackageBO : submitQuotationBillReqBO.getPackageList()) {
                    DIqrQuotationPkgPO dIqrQuotationPkgPO = new DIqrQuotationPkgPO();
                    dIqrQuotationPkgPO.setInquiryPkgId(quotationPackageBO.getInquiryPkgId());
                    dIqrQuotationPkgPO.setQuotationId(submitQuotationBillReqBO.getQuotationId());
                    dIqrQuotationPkgPO.setQuoteExplain(quotationPackageBO.getQuoteExplain());
                    if (pkgQuoteAmountMap.size() > 0 && pkgQuoteAmountMap.get(quotationPackageBO.getInquiryPkgId()) != null) {
                        dIqrQuotationPkgPO.setAmount(0L);
                        dIqrQuotationPkgPO.setAmountSec(QuoteUtil.encode((Long)pkgQuoteAmountMap.get(quotationPackageBO.getInquiryPkgId()), submitQuotationBillReqBO.getQuotationId().toString()));
                    } else if (totalPriceFlag != null && "Y".equals(totalPriceFlag)) {
                        dIqrQuotationPkgPO.setAmount(0L);
                        dIqrQuotationPkgPO.setAmountSec(QuoteUtil.encode(MoneyUtils.BigDecimal2Long((BigDecimal)quotationPackageBO.getAmount()), submitQuotationBillReqBO.getQuotationId().toString()));
                    }
                    dIqrQuotationPkgPO.setQuoteIpAddr(submitQuotationBillReqBO.getQuoteIpAddr());
                    dIqrQuotationPkgPO.setDocStatus(Integer.valueOf("4002"));
                    dIqrQuotationPkgPO.setNodeStatus(Integer.valueOf("4102"));
                    if ("22".equals(docType) && quotationPO.getQuoteTimeLimit() != null) {
                        updateQuotationPO.setQuoteRounds(quotationPO.getQuoteTimeLimit().toString());
                    } else if (StringUtils.isNotEmpty((CharSequence)quotationPO.getQuoteRounds())) {
                        Integer quoteRounds = Integer.valueOf(quotationPO.getQuoteRounds()) + 1;
                        updateQuotationPO.setQuoteRounds(quoteRounds.toString());
                    } else {
                        updateQuotationPO.setQuoteRounds("1");
                    }
                    quotationPkgList.add(dIqrQuotationPkgPO);
                }
                this.dIqrQuotationPkgMapper.updateByIdList(quotationPkgList, submitQuotationBillReqBO.getQuotationId());
            }
            catch (Exception e) {
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u66f4\u65b0\u62a5\u4ef7\u5305\u660e\u7ec6\u5355\u5931\u8d25");
                log.error("\u66f4\u65b0\u62a5\u4ef7\u5305\u660e\u7ec6\u5355\u5931\u8d25\uff1a", (Throwable)e);
                throw new BusinessException("9999", "\u66f4\u65b0\u62a5\u4ef7\u5305\u660e\u7ec6\u5355\u5931\u8d25\uff1a", (Throwable)e);
            }
        }
        try {
            this.dIqrQuotationItemMapper.updateByIdList(dIqrQuotationItemPOs, submitQuotationBillReqBO.getQuotationId());
        }
        catch (Exception e) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u66f4\u65b0\u62a5\u4ef7\u660e\u7ec6\u5355\u5931\u8d25");
            log.error("\u66f4\u65b0\u62a5\u4ef7\u660e\u7ec6\u5355\u5931\u8d25:", (Throwable)e);
            throw new BusinessException("9999", "\u66f4\u65b0\u62a5\u4ef7\u660e\u7ec6\u5355\u5931\u8d25:", (Throwable)e);
        }
        this.dIqrQuotationAttachMapper.deleteByQuotationId(submitQuotationBillReqBO.getQuotationId());
        if (submitQuotationBillReqBO.getQuoteAttachmentInfoList() != null && submitQuotationBillReqBO.getQuoteAttachmentInfoList().size() > 0) {
            ArrayList<DIqrQuotationAttachPO> dIqrQuotationAttachPOList = new ArrayList<DIqrQuotationAttachPO>();
            for (QuotationAttachmentBO quotationAttachmentBO : submitQuotationBillReqBO.getQuoteAttachmentInfoList()) {
                DIqrQuotationAttachPO dIqrQuotationAttachPO = new DIqrQuotationAttachPO();
                SeqEnquiryReqBO seqEnquiryReqBO = new SeqEnquiryReqBO();
                seqEnquiryReqBO.setSystemId("ZH01");
                seqEnquiryReqBO.setSeqType("99");
                SeqEnquiryRspBO seqEnquiryPubRspBO = this.seqIdCreateService.getSeqId(seqEnquiryReqBO);
                Long quotationAttachmentId = seqEnquiryPubRspBO.getDocId();
                dIqrQuotationAttachPO.setQuotationId(submitQuotationBillReqBO.getQuotationId());
                dIqrQuotationAttachPO.setAttachmentName(quotationAttachmentBO.getAttachmentName());
                dIqrQuotationAttachPO.setAttachmentType(quotationAttachmentBO.getAttachmentBusiType());
                dIqrQuotationAttachPO.setAttachmentUrl(quotationAttachmentBO.getAttachmentUrl());
                dIqrQuotationAttachPO.setOssPath(quotationAttachmentBO.getOssPath());
                dIqrQuotationAttachPO.setUploadTime(new Date());
                dIqrQuotationAttachPO.setUploadUserId(submitQuotationBillReqBO.getQuotationCreateUserId());
                dIqrQuotationAttachPO.setUploadUserName(submitQuotationBillReqBO.getQuotationCreateUserName());
                dIqrQuotationAttachPO.setQuotationAttachmentId(quotationAttachmentId);
                dIqrQuotationAttachPOList.add(dIqrQuotationAttachPO);
            }
            this.dIqrQuotationAttachMapper.insertBatch(dIqrQuotationAttachPOList);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u62a5\u4ef7\u5355\u66f4\u65b0\u6210\u529f");
        rspBO.setQuotationId(submitQuotationBillReqBO.getQuotationId());
        log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
        return rspBO;
    }

    public SubmitQuotationBillRspBO addQuotationBill(SubmitQuotationBillReqBO submitQuotationBillReqBO, String docType, String busiType, List<DIqrQuotationItemPO> dIqrQuotationItemPOs, String totalPriceFlag, DIqrQuotationPO quotationPO, BigDecimal mostQuotationItemQrice) {
        SubmitQuotationBillRspBO rspBO = new SubmitQuotationBillRspBO();
        DIqrQuotationPO addQuotationPO = new DIqrQuotationPO();
        BeanUtils.copyProperties((Object)quotationPO, (Object)addQuotationPO);
        SeqEnquiryReqBO seqEnquiryReqBO = new SeqEnquiryReqBO();
        seqEnquiryReqBO.setSystemId("ZH01");
        seqEnquiryReqBO.setSeqType("4");
        SeqEnquiryRspBO seqEnquiryPubRspBO = this.seqIdCreateService.getSeqId(seqEnquiryReqBO);
        Long quotationId = seqEnquiryPubRspBO.getDocId();
        HashMap<String, Long> pkgQuoteAmountMap = new HashMap<String, Long>();
        Long quoteAmount = 0L;
        BigDecimal amount = new BigDecimal("0");
        if (!"Y".equals(totalPriceFlag)) {
            try {
                for (DIqrQuotationItemPO dIqrQuotationItemPO : dIqrQuotationItemPOs) {
                    if (dIqrQuotationItemPO.getQuotePrice() == null && StringUtils.isBlank((CharSequence)dIqrQuotationItemPO.getQuotePriceSec())) continue;
                    BigDecimal itemQuoteAmount = new BigDecimal("0");
                    Object quotePrice = dIqrQuotationItemPO.getQuotePrice();
                    if (StringUtils.isNotEmpty((CharSequence)dIqrQuotationItemPO.getQuotePriceSec())) {
                        quotePrice = QuoteUtil.decode(dIqrQuotationItemPO.getQuotePriceSec(), dIqrQuotationItemPO.getQuotationId().toString());
                    }
                    itemQuoteAmount = MoneyUtils.Long2BigDecimal((Long)quotePrice).multiply(MoneyUtils.Long2BigDecimal((Long)dIqrQuotationItemPO.getPurchaseNum())).setScale(2, 4);
                    dIqrQuotationItemPO.setQuoteAmount(0L);
                    dIqrQuotationItemPO.setQuoteAmountSec(QuoteUtil.encode(MoneyUtils.BigDecimal2Long((BigDecimal)itemQuoteAmount), quotationId.toString().toString()));
                    dIqrQuotationItemPO.setQuotePrice(0L);
                    dIqrQuotationItemPO.setQuotePriceSec(QuoteUtil.encode((Long)quotePrice, quotationId.toString().toString()));
                    quoteAmount = MoneyUtils.BigDecimal2Long((BigDecimal)itemQuoteAmount) + quoteAmount;
                    if (StringUtils.isNotBlank((CharSequence)dIqrQuotationItemPO.getInquiryPkgId()) && pkgQuoteAmountMap.size() <= 0) {
                        pkgQuoteAmountMap.put(dIqrQuotationItemPO.getInquiryPkgId(), MoneyUtils.BigDecimal2Long((BigDecimal)itemQuoteAmount));
                    } else if (StringUtils.isNotBlank((CharSequence)dIqrQuotationItemPO.getInquiryPkgId()) && pkgQuoteAmountMap.get(dIqrQuotationItemPO.getInquiryPkgId()) == null) {
                        pkgQuoteAmountMap.put(dIqrQuotationItemPO.getInquiryPkgId(), MoneyUtils.BigDecimal2Long((BigDecimal)itemQuoteAmount));
                    } else if (StringUtils.isNotBlank((CharSequence)dIqrQuotationItemPO.getInquiryPkgId())) {
                        Long pkgQuoteAmount = (Long)pkgQuoteAmountMap.get(dIqrQuotationItemPO.getInquiryPkgId());
                        pkgQuoteAmount = pkgQuoteAmount + MoneyUtils.BigDecimal2Long((BigDecimal)itemQuoteAmount);
                        pkgQuoteAmountMap.put(dIqrQuotationItemPO.getInquiryPkgId(), pkgQuoteAmount);
                    }
                    dIqrQuotationItemPO.setQuotationId(quotationId);
                }
                addQuotationPO.setAmount(0L);
                addQuotationPO.setAmountSec(QuoteUtil.encode(quoteAmount, quotationId.toString()));
                amount = MoneyUtils.Long2BigDecimal((Long)quoteAmount);
            }
            catch (Exception e) {
                log.error("\u91d1\u989d\u8f6c\u5316\u6216\u8ba1\u7b97\u5f02\u5e38", (Throwable)e);
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u91d1\u989d\u8f6c\u5316\u6216\u8ba1\u7b97\u5f02\u5e38");
                throw new BusinessException("9999", "\u66f4\u65b0\u62a5\u4ef7\u5355\u5931\u8d25\uff1a", (Throwable)e);
            }
        }
        try {
            addQuotationPO.setAmount(0L);
            addQuotationPO.setAmountSec(QuoteUtil.encode(MoneyUtils.BigDecimal2Long((BigDecimal)submitQuotationBillReqBO.getAmount()), quotationId.toString()));
            amount = submitQuotationBillReqBO.getAmount();
        }
        catch (Exception e) {
            log.error("\u91d1\u989d\u8f6c\u5316\u6216\u8ba1\u7b97\u5f02\u5e38", (Throwable)e);
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u91d1\u989d\u8f6c\u5316\u6216\u8ba1\u7b97\u5f02\u5e38");
            throw new BusinessException("9999", "\u66f4\u65b0\u62a5\u4ef7\u5355\u5931\u8d25\uff1a", (Throwable)e);
        }
        if ("23".equals(docType) && "2".equals(busiType) && mostQuotationItemQrice != null && mostQuotationItemQrice.compareTo(BigDecimal.ZERO) > 0 && amount.compareTo(mostQuotationItemQrice) < 0) {
            log.error("\u66f4\u65b0\u62a5\u4ef7\u5355\u5931\u8d25\uff1a\u62a5\u4ef7\u603b\u91d1\u989d\u4e0d\u53ef\u4ee5\u4f4e\u4e8e" + mostQuotationItemQrice);
            rspBO.setRespCode("9900");
            rspBO.setRespDesc("\u66f4\u65b0\u62a5\u4ef7\u5355\u5931\u8d25\uff1a\u62a5\u4ef7\u603b\u91d1\u989d\u4e0d\u53ef\u4ee5\u4f4e\u4e8e" + mostQuotationItemQrice);
            return rspBO;
        }
        if ("23".equals(docType) && !"2".equals(busiType) && mostQuotationItemQrice != null && mostQuotationItemQrice.compareTo(BigDecimal.ZERO) > 0 && amount.compareTo(mostQuotationItemQrice) > 0) {
            log.error("\u66f4\u65b0\u62a5\u4ef7\u5355\u5931\u8d25\uff1a\u62a5\u4ef7\u603b\u91d1\u989d\u4e0d\u53ef\u4ee5\u9ad8\u4e8e" + mostQuotationItemQrice);
            rspBO.setRespCode("9900");
            rspBO.setRespDesc("\u66f4\u65b0\u62a5\u4ef7\u5355\u5931\u8d25\uff1a\u62a5\u4ef7\u603b\u91d1\u989d\u4e0d\u53ef\u4ee5\u9ad8\u4e8e" + mostQuotationItemQrice);
            return rspBO;
        }
        if (!"23".equals(docType) && "2".equals(busiType) && mostQuotationItemQrice != null && mostQuotationItemQrice.compareTo(BigDecimal.ZERO) > 0 && amount.compareTo(mostQuotationItemQrice) < 0) {
            log.error("\u66f4\u65b0\u62a5\u4ef7\u5355\u5931\u8d25\uff1a\u62a5\u4ef7\u603b\u91d1\u989d\u4e0d\u53ef\u4ee5\u4f4e\u4e8e" + mostQuotationItemQrice);
            rspBO.setRespCode("9900");
            rspBO.setRespDesc("\u66f4\u65b0\u62a5\u4ef7\u5355\u5931\u8d25\uff1a\u62a5\u4ef7\u603b\u91d1\u989d\u4e0d\u53ef\u4ee5\u4f4e\u4e8e" + mostQuotationItemQrice);
            return rspBO;
        }
        if (!"23".equals(docType) && !"2".equals(busiType) && mostQuotationItemQrice != null && mostQuotationItemQrice.compareTo(BigDecimal.ZERO) > 0 && amount.compareTo(mostQuotationItemQrice) > 0) {
            log.error("\u66f4\u65b0\u62a5\u4ef7\u5355\u5931\u8d25\uff1a\u62a5\u4ef7\u603b\u91d1\u989d\u4e0d\u53ef\u4ee5\u4f4e\u4e8e" + mostQuotationItemQrice);
            rspBO.setRespCode("9900");
            rspBO.setRespDesc("\u66f4\u65b0\u62a5\u4ef7\u5355\u5931\u8d25\uff1a\u62a5\u4ef7\u603b\u91d1\u989d\u4e0d\u53ef\u4ee5\u9ad8\u4e8e" + mostQuotationItemQrice);
            return rspBO;
        }
        log.info("\u62a5\u4ef7\u5355\u8054\u7cfb\u4eba\u4e3a\uff1a" + submitQuotationBillReqBO.getSupplierContactName() + ";\u62a5\u4ef7\u5355\u8054\u7cfb\u65b9\u5f0f\u4e3a\uff1a" + submitQuotationBillReqBO.getSupplierContactTele());
        if (!"23".equals(docType)) {
            addQuotationPO.setSupplierContactName(submitQuotationBillReqBO.getSupplierContactName());
            addQuotationPO.setSupplierContactTele(submitQuotationBillReqBO.getSupplierContactTele());
            if (StringUtils.isNotBlank((CharSequence)submitQuotationBillReqBO.getDeliveryDatePromise()) && submitQuotationBillReqBO.getDeliveryDatePromise().length() == 10) {
                addQuotationPO.setDeliveryDatePromise(DateUtils.strToDateLong((String)submitQuotationBillReqBO.getDeliveryDatePromise(), (String)"yyyy-MM-dd"));
            } else {
                addQuotationPO.setDeliveryDatePromise(DateUtils.strToDateLong((String)submitQuotationBillReqBO.getDeliveryDatePromise(), (String)"yyyy-MM-dd HH:mm:ss"));
            }
            addQuotationPO.setDeliveryIntPromise(submitQuotationBillReqBO.getDeliveryIntPromise());
        } else {
            DIqrRegistDocPO iqrRegistDocPO = this.dIqrRegistDocMapper.selectByPrimaryKey(quotationPO.getRegistId());
            if (iqrRegistDocPO != null) {
                addQuotationPO.setDeliveryIntPromise(iqrRegistDocPO.getDeliveryIntPromise());
                addQuotationPO.setDeliveryDatePromise(iqrRegistDocPO.getDeliveryDatePromise());
                addQuotationPO.setSupplierContactName(iqrRegistDocPO.getSupplierContactName());
                addQuotationPO.setSupplierContactTele(iqrRegistDocPO.getSupplierContactTele());
            }
        }
        addQuotationPO.setQuoteExplain(submitQuotationBillReqBO.getQuoteExplain());
        addQuotationPO.setQuotationSubmitTime(new Date());
        addQuotationPO.setDocStatus(Integer.valueOf("4002"));
        addQuotationPO.setNodeStatus(Integer.valueOf("4102"));
        addQuotationPO.setQuotationId(quotationId);
        addQuotationPO.setQuoteIpAddr(submitQuotationBillReqBO.getQuoteIpAddr());
        if ("22".equals(docType) && quotationPO.getQuoteTimeLimit() != null) {
            addQuotationPO.setQuoteRounds(quotationPO.getQuoteTimeLimit().toString());
        } else if (StringUtils.isNotEmpty((CharSequence)quotationPO.getQuoteRounds())) {
            Integer quoteRounds = Integer.valueOf(quotationPO.getQuoteRounds()) + 1;
            addQuotationPO.setQuoteRounds(quoteRounds.toString());
        } else {
            addQuotationPO.setQuoteRounds("1");
        }
        addQuotationPO.setQuotationCreateUserId(submitQuotationBillReqBO.getUserId());
        addQuotationPO.setQuotationCreateUserName(submitQuotationBillReqBO.getUsername());
        addQuotationPO.setLastRoundQuotationId(submitQuotationBillReqBO.getQuotationId());
        if ("23".equals(docType)) {
            try {
                DIqrQuotationPkgPO updateQuotationPkg = new DIqrQuotationPkgPO();
                updateQuotationPkg.setQuotationId(submitQuotationBillReqBO.getQuotationId());
                updateQuotationPkg.setHisStatus("2");
                this.dIqrQuotationPkgMapper.updateByQuotationId(updateQuotationPkg);
            }
            catch (Exception e) {
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u66f4\u65b0\u62a5\u4ef7\u5305\u660e\u7ec6\u5931\u8d25");
                log.error("\u66f4\u65b0\u62a5\u4ef7\u5305\u660e\u7ec6\u5931\u8d25\uff1a", (Throwable)e);
                throw new BusinessException("9999", "\u66f4\u65b0\u62a5\u4ef7\u5305\u660e\u7ec6\u5931\u8d25\uff1a", (Throwable)e);
            }
            try {
                ArrayList<DIqrQuotationPkgPO> addIqrQuotationPkgList = new ArrayList<DIqrQuotationPkgPO>();
                List<DIqrQuotationPkgPO> oldQuotationPkgList = this.dIqrQuotationPkgMapper.selectByQuotationId(submitQuotationBillReqBO.getQuotationId());
                int count = 0;
                for (DIqrQuotationPkgPO quotationPkgPO : oldQuotationPkgList) {
                    DIqrQuotationPkgPO dIqrQuotationPkgPO = new DIqrQuotationPkgPO();
                    dIqrQuotationPkgPO.setInquiryPkgId(quotationPkgPO.getInquiryPkgId());
                    dIqrQuotationPkgPO.setQuotationId(quotationId);
                    dIqrQuotationPkgPO.setQuotationPkgId(quotationId + "-" + ++count);
                    dIqrQuotationPkgPO.setInquiryId(quotationPkgPO.getInquiryId());
                    dIqrQuotationPkgPO.setHisStatus("1");
                    dIqrQuotationPkgPO.setValidStatus(Constants.IS_VALID_Y);
                    dIqrQuotationPkgPO.setDocStatus(Integer.valueOf("4002"));
                    dIqrQuotationPkgPO.setNodeStatus(Integer.valueOf("4102"));
                    dIqrQuotationPkgPO.setQuotePkgDetailNum(quotationPkgPO.getQuotePkgDetailNum());
                    if ("22".equals(docType) && quotationPO.getQuoteTimeLimit() != null) {
                        dIqrQuotationPkgPO.setQuoteRounds(quotationPO.getQuoteTimeLimit().toString());
                    } else if (StringUtils.isNotEmpty((CharSequence)quotationPO.getQuoteRounds())) {
                        Integer quoteRounds = Integer.valueOf(quotationPO.getQuoteRounds()) + 1;
                        dIqrQuotationPkgPO.setQuoteRounds(quoteRounds.toString());
                    } else {
                        dIqrQuotationPkgPO.setQuoteRounds("1");
                    }
                    for (QuotationPackageBO quotationPackageBO : submitQuotationBillReqBO.getPackageList()) {
                        if (!quotationPackageBO.getInquiryPkgId().equals(quotationPkgPO.getInquiryPkgId())) continue;
                        dIqrQuotationPkgPO.setQuoteExplain(quotationPackageBO.getQuoteExplain());
                        if (pkgQuoteAmountMap.size() > 0 && pkgQuoteAmountMap.get(quotationPackageBO.getInquiryPkgId()) != null) {
                            dIqrQuotationPkgPO.setAmount(0L);
                            dIqrQuotationPkgPO.setAmountSec(QuoteUtil.encode((Long)pkgQuoteAmountMap.get(quotationPackageBO.getInquiryPkgId()), quotationId.toString()));
                        }
                        dIqrQuotationPkgPO.setQuoteIpAddr(submitQuotationBillReqBO.getQuoteIpAddr());
                        if (totalPriceFlag == null || !"Y".equals(totalPriceFlag)) break;
                        dIqrQuotationPkgPO.setAmount(0L);
                        dIqrQuotationPkgPO.setAmountSec(QuoteUtil.encode(MoneyUtils.BigDecimal2Long((BigDecimal)quotationPackageBO.getAmount()), quotationId.toString()));
                        break;
                    }
                    addIqrQuotationPkgList.add(dIqrQuotationPkgPO);
                }
                this.dIqrQuotationPkgMapper.insertBatch(addIqrQuotationPkgList);
            }
            catch (Exception e) {
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u65b0\u589e\u62a5\u4ef7\u5931\u8d25");
                log.error("\u65b0\u589e\u62a5\u4ef7\u5931\u8d25\uff1a", (Throwable)e);
                throw new BusinessException("9999", "\u65b0\u589e\u62a5\u4ef7\u5931\u8d25\uff1a", (Throwable)e);
            }
        }
        try {
            for (DIqrQuotationItemPO dIqrQuotationItemPO : dIqrQuotationItemPOs) {
                dIqrQuotationItemPO.setQuotationId(quotationId);
            }
            this.dIqrQuotationItemMapper.insertBatch(dIqrQuotationItemPOs);
        }
        catch (Exception e) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u65b0\u589e\u62a5\u4ef7\u62a5\u4ef7\u660e\u7ec6\u5931\u8d25");
            log.error("\u65b0\u589e\u62a5\u4ef7\u62a5\u4ef7\u660e\u7ec6\u5931\u8d25\uff1a", (Throwable)e);
            throw new BusinessException("9999", "\u65b0\u589e\u62a5\u4ef7\u62a5\u4ef7\u660e\u7ec6\u5931\u8d25\uff1a", (Throwable)e);
        }
        try {
            if (submitQuotationBillReqBO.getQuoteAttachmentInfoList() != null && submitQuotationBillReqBO.getQuoteAttachmentInfoList().size() > 0) {
                ArrayList<DIqrQuotationAttachPO> dIqrQuotationAttachPOList = new ArrayList<DIqrQuotationAttachPO>();
                for (QuotationAttachmentBO quotationAttachmentBO : submitQuotationBillReqBO.getQuoteAttachmentInfoList()) {
                    DIqrQuotationAttachPO dIqrQuotationAttachPO = new DIqrQuotationAttachPO();
                    SeqEnquiryReqBO attaSeqEnquiryReqBO = new SeqEnquiryReqBO();
                    attaSeqEnquiryReqBO.setSystemId("ZH01");
                    attaSeqEnquiryReqBO.setSeqType("99");
                    SeqEnquiryRspBO attaSeqEnquiryPubRspBO = this.seqIdCreateService.getSeqId(attaSeqEnquiryReqBO);
                    Long quotationAttachmentId = attaSeqEnquiryPubRspBO.getDocId();
                    dIqrQuotationAttachPO.setQuotationId(submitQuotationBillReqBO.getQuotationId());
                    dIqrQuotationAttachPO.setAttachmentName(quotationAttachmentBO.getAttachmentName());
                    dIqrQuotationAttachPO.setAttachmentType(quotationAttachmentBO.getAttachmentBusiType());
                    dIqrQuotationAttachPO.setAttachmentUrl(quotationAttachmentBO.getAttachmentUrl());
                    dIqrQuotationAttachPO.setOssPath(quotationAttachmentBO.getOssPath());
                    dIqrQuotationAttachPO.setUploadTime(new Date());
                    dIqrQuotationAttachPO.setUploadUserId(submitQuotationBillReqBO.getQuotationCreateUserId());
                    dIqrQuotationAttachPO.setUploadUserName(submitQuotationBillReqBO.getQuotationCreateUserName());
                    dIqrQuotationAttachPO.setQuotationAttachmentId(quotationAttachmentId);
                    dIqrQuotationAttachPOList.add(dIqrQuotationAttachPO);
                }
                this.dIqrQuotationAttachMapper.insertBatch(dIqrQuotationAttachPOList);
            }
        }
        catch (Exception e) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u65b0\u589e\u62a5\u4ef7\u9644\u4ef6\u5931\u8d25");
            log.error("\u65b0\u589e\u62a5\u4ef7\u9644\u4ef6\u5931\u8d25\uff1a", (Throwable)e);
            throw new BusinessException("9999", "\u65b0\u589e\u62a5\u4ef7\u9644\u4ef6\u5931\u8d25\uff1a", (Throwable)e);
        }
        try {
            this.dIqrQuotationMapper.insertSelective(addQuotationPO);
        }
        catch (Exception e) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u65b0\u589e\u62a5\u4ef7\u5931\u8d25");
            log.error("\u65b0\u589e\u62a5\u4ef7\u5931\u8d25\uff1a", (Throwable)e);
            throw new BusinessException("9999", "\u65b0\u589e\u62a5\u4ef7\u5931\u8d25\uff1a", (Throwable)e);
        }
        try {
            DIqrQuotationPO updateQuotationPO = new DIqrQuotationPO();
            updateQuotationPO.setHisStatus("2");
            updateQuotationPO.setQuotationId(submitQuotationBillReqBO.getQuotationId());
            this.dIqrQuotationMapper.updateByPrimaryKeySelective(updateQuotationPO);
        }
        catch (Exception e) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u66f4\u65b0\u62a5\u4ef7\u5931\u8d25");
            log.error("\u66f4\u65b0\u62a5\u4ef7\u5931\u8d25\uff1a", (Throwable)e);
            throw new BusinessException("9999", "\u66f4\u65b0\u62a5\u4ef7\u5931\u8d25\uff1a", (Throwable)e);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u62a5\u4ef7\u5355\u66f4\u65b0\u5e76\u65b0\u589e\u6210\u529f");
        rspBO.setQuotationId(quotationId);
        log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
        return rspBO;
    }

    public SubmitQuotationBillRspBO checkQuoteItem(String busiType, String totalPriceFlag, String docType, Integer quoteMethod, List<DIqrQuotationItemMidPO> quotationItemPOList, List<DIqrQuotationItemPO> quotationItemPOs) {
        Integer wrongCount = 0;
        String wrongStr = "";
        HashSet<String> notQuotationPkgIdSet = new HashSet<String>();
        HashSet<String> quotationPkgIdSet = new HashSet<String>();
        SubmitQuotationBillRspBO rspBO = new SubmitQuotationBillRspBO();
        for (DIqrQuotationItemMidPO quotationItemjsonBO : quotationItemPOList) {
            Integer n;
            Integer n2;
            if ("2".equals(busiType)) {
                if (!"Y".equals(totalPriceFlag) && (quotationItemjsonBO.getQuotePrice() == null || quotationItemjsonBO.getQuotePrice() == 0L) && StringUtils.isEmpty((CharSequence)quotationItemjsonBO.getQuotePriceSec())) {
                    n2 = wrongCount;
                    n = wrongCount = Integer.valueOf(wrongCount + 1);
                    log.error("\u62a5\u4ef7\u5355\u660e\u7ec6\u6821\u9a8c\u5931\u8d25---\u62a5\u4ef7\u5355\u4ef7\u4e3a\u7a7a");
                    wrongStr = wrongStr + "\u62a5\u4ef7\u5355\u660e\u7ec6\u6821\u9a8c\u5931\u8d25---\u62a5\u4ef7\u5355\u4ef7\u4e3a\u7a7a\u62160;";
                    continue;
                }
                if (!"Y".equals(totalPriceFlag) && (quotationItemjsonBO.getQuoteAmount() == null || quotationItemjsonBO.getQuoteAmount() == 0L) && StringUtils.isEmpty((CharSequence)quotationItemjsonBO.getQuoteAmountSec())) {
                    n2 = wrongCount;
                    n = wrongCount = Integer.valueOf(wrongCount + 1);
                    log.error("\u62a5\u4ef7\u5355\u660e\u7ec6\u6821\u9a8c\u5931\u8d25---\u62a5\u4ef7\u603b\u4ef7\u4e3a\u7a7a");
                    wrongStr = wrongStr + "\u62a5\u4ef7\u5355\u660e\u7ec6\u6821\u9a8c\u5931\u8d25---\u62a5\u4ef7\u603b\u4ef7\u4e3a\u7a7a\u62160;";
                    notQuotationPkgIdSet.add(quotationItemjsonBO.getInquiryPkgId());
                    continue;
                }
                if ("Y".equals(totalPriceFlag)) continue;
                quotationPkgIdSet.add(quotationItemjsonBO.getInquiryPkgId());
                continue;
            }
            if (!"Y".equals(totalPriceFlag) && (quotationItemjsonBO.getQuotePrice() == null || quotationItemjsonBO.getQuotePrice() == 0L) && StringUtils.isEmpty((CharSequence)quotationItemjsonBO.getQuotePriceSec())) {
                n2 = wrongCount;
                n = wrongCount = Integer.valueOf(wrongCount + 1);
                log.error("\u62a5\u4ef7\u5355\u660e\u7ec6\u6821\u9a8c\u5931\u8d25---\u62a5\u4ef7\u5355\u4ef7\u4e3a\u7a7a");
                wrongStr = wrongStr + "\u62a5\u4ef7\u5355\u660e\u7ec6\u6821\u9a8c\u5931\u8d25---\u62a5\u4ef7\u5355\u4ef7\u4e3a\u7a7a\u62160;";
                continue;
            }
            if (!"Y".equals(totalPriceFlag) && (quotationItemjsonBO.getQuoteAmount() == null || quotationItemjsonBO.getQuoteAmount() == 0L) && StringUtils.isEmpty((CharSequence)quotationItemjsonBO.getQuoteAmountSec())) {
                n2 = wrongCount;
                n = wrongCount = Integer.valueOf(wrongCount + 1);
                log.error("\u62a5\u4ef7\u5355\u660e\u7ec6\u6821\u9a8c\u5931\u8d25---\u62a5\u4ef7\u603b\u4ef7\u4e3a\u7a7a");
                wrongStr = wrongStr + "\u62a5\u4ef7\u5355\u660e\u7ec6\u6821\u9a8c\u5931\u8d25---\u62a5\u4ef7\u603b\u4ef7\u4e3a\u7a7a\u62160;";
                notQuotationPkgIdSet.add(quotationItemjsonBO.getInquiryPkgId());
                continue;
            }
            if (!"Y".equals(totalPriceFlag)) {
                quotationPkgIdSet.add(quotationItemjsonBO.getInquiryPkgId());
            }
            if (!"Y".equals(totalPriceFlag) && StringUtils.isBlank((CharSequence)quotationItemjsonBO.getBrand())) {
                n2 = wrongCount;
                n = wrongCount = Integer.valueOf(wrongCount + 1);
                log.error("\u62a5\u4ef7\u5355\u660e\u7ec6\u6821\u9a8c\u5931\u8d25---\u54c1\u724c\u4e3a\u7a7a");
                wrongStr = wrongStr + "\u62a5\u4ef7\u5355\u660e\u7ec6\u6821\u9a8c\u5931\u8d25---\u54c1\u724c\u4e3a\u7a7a;";
                continue;
            }
            if ("Y".equals(totalPriceFlag) || !StringUtils.isBlank((CharSequence)quotationItemjsonBO.getManufacturer())) continue;
            n2 = wrongCount;
            n = wrongCount = Integer.valueOf(wrongCount + 1);
            log.error("\u62a5\u4ef7\u5355\u660e\u7ec6\u6821\u9a8c\u5931\u8d25---\u751f\u4ea7\u5382\u5bb6\u4e3a\u7a7a");
            wrongStr = wrongStr + "\u62a5\u4ef7\u5355\u660e\u7ec6\u6821\u9a8c\u5931\u8d25---\u751f\u4ea7\u5382\u5bb6\u4e3a\u7a7a;";
        }
        if (quoteMethod != null && "2".equals(quoteMethod.toString()) && "23".equals(docType) && quotationPkgIdSet.size() > 0) {
            for (String notQuotationPkgId : notQuotationPkgIdSet) {
                if (!quotationPkgIdSet.contains(notQuotationPkgId)) continue;
                log.error("\u62a5\u4ef7\u5355\u660e\u7ec6 \u5206\u9879\u5305\u53f7" + notQuotationPkgId + "-\u62a5\u4ef7\u5355\u4ef7\uff08\u5143\uff09\u4e0d\u80fd\u4e3a\u7a7a");
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u62a5\u4ef7\u5355\u660e\u7ec6 \u5206\u9879\u5305\u53f7" + notQuotationPkgId + "-\u62a5\u4ef7\u5355\u4ef7\uff08\u5143\uff09\u4e0d\u80fd\u4e3a\u7a7a");
                return rspBO;
            }
        } else if (wrongCount > 0) {
            rspBO.setRespCode("9900");
            rspBO.setRespDesc(wrongStr);
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u660e\u7ec6\u6821\u9a8c\u6210\u529f");
        return rspBO;
    }
}

