package com.tydic.dyc.pro.base.bo.esmapping;

import lombok.Data;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 标题：DycProEsIndexMappingChngOrderBO
 * 描述：变更单索引映射
 */
@Data
public class DycProEsIndexMappingChngOrderBO implements Serializable {

    private static final long serialVersionUID = 362056981903882029L;

    /**
     * 变更单id
     */
    private Long chngOrderId;

    /**
     * 订单id
     */
    private Long orderId;

    /**
     * 变更单编号
     */
    private String chngOrderNo;
    /**
     * 业务类型 1:异常变更 2订单调价3订单取消
     */
    private Integer busiType;
    /**
     * 变更单状态
     */
    private String chngOrderState;
    /**
     * 撤单原因
     */
    private String cancelReason;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 创建人名称
     */
    private String createOperName;

    /**
     * 验收单编码
     */
    private String inspOrderNo;

    /**
     * 变更单退付款类型：1付款，2退款
     */
    private Integer addOrSubtractType;

    /**
     * 发货单编码集合
     */
    private List<String> shipOrderNoList;

    /**
     * 销售单编码
     */
    private String saleOrderNo;

    /**
     * 外部销售单编码
     */
    private String saleOrderNoExt;

    /**
     * 结算模式 2:撮合 1:贸易
     */
    private Integer modelSettle;

    /**
     * 下单时间
     */
    private Date orderCreateTime;

    /**
     * 下单人名称
     */
    private String orderCreateOperName;

    /**
     * 验收单状态
     */
    private String inspOrderState;
    /**
     * 销售金额
     */
    private BigDecimal totalSaleFee;
    /**
     * 采购金额
     */
    private BigDecimal totalPurchaseFee;
    /**
     * 订单来源 ： 2：电商订单 3：协议订单
     */
    private Integer orderSource;
    /**
     * 平台协议编号
     */
    private String plaAgreementCode;

    /**
     * 协议名称
     */
    private String agreementName;

    /**
     * 验收时间
     */
    private Date inspCreateTime;

    /**
     * 验收人名称
     */
    private String inspCreateOperName;

    /**
     * 销售单三方信息
     */
    private DycProEsIndexMappingSaleStakeholderBO saleStakeholder;
    /**
     * 变更单对象集合
     */
    private List<DycProEsIndexMappingChngOrderObjBO> chngOrderObjList;
    /**
     * 取消申请单对应的销售单明细
     */
    private List<DycProEsIndexMappingSaleOrderItemBO> saleOrderItemList;

}
