package com.tydic.dyc.pro.base.core.dictionary.enums;

/**
 * @description 停启用标识 0 停用 1 启用
 * @author Luokan
 * @date 2025/04/23
 **/

public enum EnableFlag implements DictionaryEnum{
    /**
     * 0 停用
     */
    STOP_USE("ENABLE_FLAG", "0","停用", "停启用标识"),
    /**
     * 1 启用
     */
    USE("ENABLE_FLAG", "1","启用", "停启用标识");
    /**
     * 编码
     */
    private String dictionaryCode;
    /**
     * 编码
     */
    private String code;
    /**
     * 编码值
     */
    private String value;
    /**
     * 名称
     */
    private String dictionaryName;

    EnableFlag(String dictionaryCode, String code, String value, String dictionaryName) {
        this.dictionaryCode = dictionaryCode;
        this.code = code;
        this.value = value;
        this.dictionaryName = dictionaryName;
    }
    public String getDictionaryCode() {
        return dictionaryCode;
    }

    public String getDictionaryName() {
        return dictionaryName;
    }

    public String getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}
