package com.tydic.dyc.pro.base.bo.esmapping;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @Author yuhao
 * @Date 2025/5/26 11:00
 * @Description:sku es index 映射对象
 **/
@Data
public class DycProEsIndexMappingSkuInUpcBO implements Serializable {
    private static final long serialVersionUID = -7124454027259804715L;
    /**
     * sku id
     */
    private Long skuId;
    /**
     * spu id
     */
    private Long spuId;
    /**
     * sku编码
     */
    private String skuCode;
    /**
     * 主图地址
     */
    private String mainImageUrl;
    /**
     * sku来源:
     * 2:电商sku
     * 3:协议sku
     */
    private Integer skuSource;
    /**
     * sku名称
     */
    private String skuName;
    /**
     * sku状态
     * 0：草稿
     * 1：待上架
     * 2：已上架
     * 3：已冻结
     * 4：已失效
     * 5：合规校验失败
     */
    private Integer skuStatus;
    /**
     * 外部spu id
     */
    private String extSpuId;
    /**
     * 外部sku id
     */
    private String extSkuId;
    /**
     * 69码
     */
    private String eanCode;
    /**
     * 审核状态
     */
    private Integer approvalStatus;
    /**
     * 检测状态:
     * 1:待检测
     * 2:检测中
     * 3:检测通过
     * 4:检测不通过
     */
    private Integer examineStatus;
    /**
     * 品牌名称
     */
    private String brandName;
    /**
     * 所属协议id
     */
    private Long agrId;
    /**
     * 所属协议明细id
     */
    private Long agrItemId;
    /**
     * 交易模式：1：贸易模式 2：搓合模式
     */
    private Integer tradeMode;
    /**
     * 协议编号
     */
    private String agrCode;
    /**
     * 协议名称
     */
    private String agrName;
    /**
     * 企业协议编号
     */
    private String enAgrCode;
    /**
     * 供货周期（协议明细上的）
     */
    private Integer supplyCycle;
    /**
     * 销售计量单位id
     */
    private Long saleMeasureId;
    /**
     * 销售计量单位名称
     */
    private String saleMeasureName;
    /**
     * 最小起订量
     */
    private BigDecimal minQuantity;
    /**
     * 税率
     */
    private BigDecimal rate;
    /**
     * 型号
     */
    private String model;
    /**
     * 规格
     */
    private String spec;
    /**
     * 供应商id
     */
    private Long supplierId;
    /**
     * 供应商名称
     */
    private String supplierName;
    /**
     * 创建人id
     */
    private Long createUserId;
    /**
     * 创建人名称
     */
    private String createUserName;
    /**
     * 创建人账号
     */
    private String createUserAccount;
    /**
     * 创建人机构id
     */
    private Long createOrgId;
    /**
     * 创建人机构名称
     */
    private String createOrgName;
    /**
     * 创建人机构路径
     */
    private String createOrgPath;
    /**
     * 创建人公司id
     */
    private Long createCompanyId;
    /**
     * 创建人公司名称
     */
    private String createCompanyName;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 市场价
     */
    private BigDecimal marketPrice;
    /**
     * 供货价
     */
    private BigDecimal supplierPrice;
    /**
     * 后台管理类目 全称
     */
    private String manageCatalogPath;
    /**
     * 后台管理类目 全称
     */
    private String manageCatalogPathName;
    /**
     * 销售价
     */
    private BigDecimal salePrice;
    /**
     * 折扣率
     */
    private BigDecimal discountRate;
    /**
     * 物料ID
     */
    private Long materialId;
    /**
     * 物料编码
     */
    private String materialCode;
    /**
     * 物料名称
     */
    private String materialName;
    /**
     * 商品禁售记录
     */
    private List<DycProEsIndexMappingBansRuleBO> bansRuleList;
}
