package com.tydic.dyc.pro.base.core.dictionary.enums;

/**
 * @author lihulin
 * @description 布尔通用是否标识 1 是    0 否
 * @date 2025/05/14
 **/

public enum BooleanFlag implements DictionaryEnum {
    /**
     * 1 是
     */
    YES("BOOLEAN_FLAG", "1", "是", "布尔通用是否标识"),
    /**
     * 0 否
     */
    NO("BOOLEAN_FLAG", "0", "否", "布尔通用是否标识");
    /**
     * 编码
     */
    private String dictionaryCode;
    /**
     * 编码
     */
    private String code;
    /**
     * 编码值
     */
    private String value;
    /**
     * 名称
     */
    private String dictionaryName;

    BooleanFlag(String dictionaryCode, String code, String value, String dictionaryName) {
        this.dictionaryCode = dictionaryCode;
        this.code = code;
        this.value = value;
        this.dictionaryName = dictionaryName;
    }

    public String getDictionaryCode() {
        return dictionaryCode;
    }

    public String getDictionaryName() {
        return dictionaryName;
    }

    public String getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}
