package com.tydic.dyc.pro.base.core.dictionary.enums;

/**
 * 协议种类 枚举
 *
 * @author lihulin
 */

public enum DmcAgrMainAgrType implements DictionaryEnum {
    JCXY("DMC_AGR_MAIN_AGR_TYPE", "1", "集采协议", "协议种类"),
    DSXY("DMC_AGR_MAIN_AGR_TYPE", "2", "电商协议", "协议种类");
    /**
     * 编码
     */
    private String dictionaryCode;
    /**
     * 编码
     */
    private String code;
    /**
     * 编码值
     */
    private String value;
    /**
     * 名称
     */
    private String dictionaryName;

    DmcAgrMainAgrType(String dictionaryCode, String code, String value, String dictionaryName) {
        this.dictionaryCode = dictionaryCode;
        this.code = code;
        this.value = value;
        this.dictionaryName = dictionaryName;
    }

    public String getDictionaryCode() {
        return dictionaryCode;
    }

    public String getDictionaryName() {
        return dictionaryName;
    }

    public String getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}
