package com.tydic.dyc.pro.base.core.dictionary.enums;

public enum DmcCommCheckResultEnum implements DictionaryEnum{
    NORMAL("DMC_COMM_CHECK_RESULT", "0", "正常", "检测结果"),
    SUSPECT("DMC_COMM_CHECK_RESULT", "1", "疑似违规", "检测结果"),
    CONFIRM("DMC_COMM_CHECK_RESULT", "2", "确认违规", "检测结果");
    /**
     * 编码
     */
    private String dictionaryCode;
    /**
     * 编码
     */
    private String code;
    /**
     * 编码值
     */
    private String value;
    /**
     * 名称
     */
    private String dictionaryName;
    DmcCommCheckResultEnum(String dictionaryCode, String code, String value, String dictionaryName) {
        this.dictionaryCode = dictionaryCode;
        this.code = code;
        this.value = value;
        this.dictionaryName = dictionaryName;
    }
    @Override
    public String getDictionaryCode() {
        return dictionaryCode;
    }

    @Override
    public String getDictionaryName() {
        return dictionaryName;
    }

    @Override
    public String getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}
