package com.tydic.dyc.pro.base.core.dictionary.enums;

/**
 * 标题：DmcSscConsultQuoteStatus
 * 描述：协商单报价单状态
 */
public enum DmcSscConsultShelveType implements DictionaryEnum {

    YES ("DMC_SSC_CONSULT_SHELVE_TYPE", "1", "已上架", "寻源结果是否上架状态"),
    NO ("DMC_SSC_CONSULT_SHELVE_TYPE", "0", "未上架", "寻源结果是否上架状态");

    /**
     * 编码
     */
    private String dictionaryCode;
    /**
     * 编码
     */
    private String code;
    /**
     * 编码值
     */
    private String value;
    /**
     * 名称
     */
    private String dictionaryName;

    DmcSscConsultShelveType(String dictionaryCode, String code, String value, String dictionaryName) {
        this.dictionaryCode = dictionaryCode;
        this.code = code;
        this.value = value;
        this.dictionaryName = dictionaryName;
    }

    public String getDictionaryCode() {
        return dictionaryCode;
    }

    public String getDictionaryName() {
        return dictionaryName;
    }

    public String getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}
