package com.tydic.dyc.pro.base.core.dictionary.enums;

import org.aspectj.weaver.ast.Not;

/**
 * 标题：DmcSscSupplyApplyInfoStatus
 * 描述：询价单状态
 */
public enum DmcSscConsultStatus implements DictionaryEnum {

    DRAFT ("DMC_SSC_CONSULT_STATUS", "0", "草稿", "协商单状态"),
    UNDER_APPROVAL ("DMC_SSC_CONSULT_STATUS", "1", "审批中", "协商单状态"),
    APPROVAL_REJECTED("DMC_SSC_CONSULT_STATUS", "2", "审批驳回", "协商单状态"),
    TO_BE_PUBLISHED("DMC_SSC_CONSULT_STATUS", "3", "待发布", "协商单状态"),
    NOT_STARTED("DMC_SSC_CONSULT_STATUS", "4", "未开始", "协商单状态"),
    QUOTING("DMC_SSC_CONSULT_STATUS", "5", "报价中", "协商单状态"),
    AWAITING_RESULT_CONFIRMATION("DMC_SSC_CONSULT_STATUS", "6", "待确认结果", "协商单状态"),
    QUOTATION_APPROVAL_PROCESSING("DMC_SSC_CONSULT_STATUS", "7", "询价结果审批中", "协商单状态"),
    QUOTATION_APPROVAL_REJECTED("DMC_SSC_CONSULT_STATUS", "9", "询价结果审批驳回", "协商单状态"),
    RESULT_PENDING_PUBLICATION("DMC_SSC_CONSULT_STATUS", "10", "结果待发布", "协商单状态"),
    COMPLETED("DMC_SSC_CONSULT_STATUS", "11", "已完成", "协商单状态"),
    QUOTATION_TERMINATED("DMC_SSC_CONSULT_STATUS", "12", "询价终止", "协商单状态"),
    FAIL("DMC_SSC_CONSULT_STATUS", "13", "询价失败", "协商单状态"),
    QUOTATION_DEADLINE("DMC_SSC_CONSULT_STATUS", "8", "报价截止", "协商单状态"),
    BE_SELECTED("DMC_SSC_CONSULT_STATUS", "100", "已中标", "协商单状态"),
    NOT_BE_SELECTED("DMC_SSC_CONSULT_STATUS", "101", "未中标", "协商单状态");

    /**
     * 编码
     */
    private String dictionaryCode;
    /**
     * 编码
     */
    private String code;
    /**
     * 编码值
     */
    private String value;
    /**
     * 名称
     */
    private String dictionaryName;

    DmcSscConsultStatus(String dictionaryCode, String code, String value, String dictionaryName) {
        this.dictionaryCode = dictionaryCode;
        this.code = code;
        this.value = value;
        this.dictionaryName = dictionaryName;
    }

    public String getDictionaryCode() {
        return dictionaryCode;
    }

    public String getDictionaryName() {
        return dictionaryName;
    }

    public String getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}
