package com.tydic.dyc.pro.base.core.dictionary.enums;

/**
 * 标题：DmcSscSupplyApplyInfoStatus
 * 描述：寻源-供货申请-状态
 */
public enum DmcSscSupplyApplyItemStatus implements DictionaryEnum {

    UNINQUIRY ("DMC_SSC_SUPPLY_APPLY_ITEM_STATUS", "1", "待询价", "供货申请明细状态"),
    INQUIRY_FAIL("DMC_SSC_SUPPLY_APPLY_ITEM_STATUS", "2", "询价失败", "供货申请明细状态"),
    INQUIRYING("DMC_SSC_SUPPLY_APPLY_ITEM_STATUS", "3", "询价中", "供货申请明细状态"),
    INQUIRYED("DMC_SSC_SUPPLY_APPLY_ITEM_STATUS", "4", "询价完成", "供货申请明细状态"),
    INQUIRY_STOP("DMC_SSC_SUPPLY_APPLY_ITEM_STATUS", "5", "询价终止", "供货申请明细状态"),
    RETURNED("DMC_SSC_SUPPLY_APPLY_ITEM_STATUS", "6", "已退回", "供货申请明细状态");

    /**
     * 编码
     */
    private String dictionaryCode;
    /**
     * 编码
     */
    private String code;
    /**
     * 编码值
     */
    private String value;
    /**
     * 名称
     */
    private String dictionaryName;

    DmcSscSupplyApplyItemStatus(String dictionaryCode, String code, String value, String dictionaryName) {
        this.dictionaryCode = dictionaryCode;
        this.code = code;
        this.value = value;
        this.dictionaryName = dictionaryName;
    }

    public String getDictionaryCode() {
        return dictionaryCode;
    }

    public String getDictionaryName() {
        return dictionaryName;
    }

    public String getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}
