package com.tydic.dyc.pro.base.core.dictionary.enums;

/**
 * 标题：EgcAfOrderPickwareType
 * 描述：订单结算单关联状态
 */
public enum FscFscOrderFscOrderRelState implements DictionaryEnum {

    UN_SUBMIT("FSC_ORDER_REL_STATE", "0", "未提交", "订单结算单关联状态"),
    SUBMITED("FSC_ORDER_REL_STATE", "1", "已提交", "订单结算单关联状态"),
    UN_SHIR("FSC_ORDER_REL_STATE", "2", "挂起", "订单结算单关联状态"),
    INVOICEING("FSC_ORDER_REL_STATE", "3", "开票中", "订单结算单关联状态"),
    INVOICED("FSC_ORDER_REL_STATE", "4", "已开票", "订单结算单关联状态"),
    HAVA_INVOICE("FSC_ORDER_REL_STATE", "5", "已收票", "订单结算单关联状态");

    /**
     * 编码
     */
    private String dictionaryCode;
    /**
     * 编码
     */
    private String code;
    /**
     * 编码值
     */
    private String value;
    /**
     * 名称
     */
    private String dictionaryName;

    FscFscOrderFscOrderRelState(String dictionaryCode, String code, String value, String dictionaryName) {
        this.dictionaryCode = dictionaryCode;
        this.code = code;
        this.value = value;
        this.dictionaryName = dictionaryName;
    }

    public String getDictionaryCode() {
        return dictionaryCode;
    }

    public String getDictionaryName() {
        return dictionaryName;
    }

    public String getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}
