package com.tydic.dyc.pro.base.core.dictionary.enums;

/**
 * 预算状态 枚举
 */
public enum GjEgcBudgetStatus implements DictionaryEnum {
    /** 草稿 */
    DRAFT("BUDGET_STATUS", "1", "草稿", "预算状态"),

    /** 审批中 */
    APPROVING("BUDGET_STATUS", "2", "审批中", "预算状态"),

    /** 待生效 */
    PENDING_EFFECTIVE("BUDGET_STATUS", "3", "待生效", "预算状态"),

    /** 已生效 */
    EFFECTIVE("BUDGET_STATUS", "4", "已生效", "预算状态"),

    /** 已失效 */
    EXPIRED("BUDGET_STATUS", "5", "已失效", "预算状态"),

    /** 已驳回 */
    REJECTED("BUDGET_STATUS", "6", "已驳回", "预算状态");

    /** 编码 */
    private final String dictionaryCode;
    /** 编码 */
    private final String code;
    /** 编码值 */
    private final String value;
    /** 名称 */
    private final String dictionaryName;

    GjEgcBudgetStatus(String dictionaryCode, String code, String value, String dictionaryName) {
        this.dictionaryCode = dictionaryCode;
        this.code = code;
        this.value = value;
        this.dictionaryName = dictionaryName;
    }

    public String getDictionaryCode() {
        return dictionaryCode;
    }

    public String getDictionaryName() {
        return dictionaryName;
    }

    public String getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}


