package com.tydic.dyc.pro.base.core.dictionary.enums;

/**
 * @author lihulin
 * @description 身份类型通用枚举
 * @date 2025/05/14
 **/

public enum IsProfessFlag implements DictionaryEnum {
    OPERATOR("IS_PROFESS_FLAG", "0", "运营单位", "身份类型通用枚举"),
    PURCHASER("IS_PROFESS_FLAG", "1", "采购单位", "身份类型通用枚举"),
    VENDOR("IS_PROFESS_FLAG", "2", "供应商", "身份类型通用枚举");
    /**
     * 编码
     */
    private String dictionaryCode;
    /**
     * 编码
     */
    private String code;
    /**
     * 编码值
     */
    private String value;
    /**
     * 名称
     */
    private String dictionaryName;

    IsProfessFlag(String dictionaryCode, String code, String value, String dictionaryName) {
        this.dictionaryCode = dictionaryCode;
        this.code = code;
        this.value = value;
        this.dictionaryName = dictionaryName;
    }

    public String getDictionaryCode() {
        return dictionaryCode;
    }

    public String getDictionaryName() {
        return dictionaryName;
    }

    public String getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}
