package com.tydic.dyc.pro.base.bo.esmapping;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 标题：DycProEsIndexMappingInspOrderBO
 * 描述：验收单索引映射
 */
@Data
public class DycProEsIndexMappingInspOrderBO implements Serializable {

    private static final long serialVersionUID = -4378583748861500828L;

    /**
     * 验收单id
     */
    private Long inspOrderId;

    /**
     * 销售单id
     */
    private Long saleOrderId;

    /**
     * 订单id
     */
    private Long orderId;

    /**
     * 验收单编码
     */
    private String inspOrderNo;

    /**
     * 验收单状态
     */
    private String inspOrderState;
    /**
     * 订单来源
     */
    private Integer orderSource;

    /**
     * 验收单销售总金额
     */
    private BigDecimal inspTotalSaleFee;

    /**
     * 验收单采购总金额
     */
    private BigDecimal inspTotalPurchaseFee;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 销售单编码
     */
    private String saleOrderNo;

    /**
     * 外部销售单编码
     */
    private String saleOrderNoExt;

    /**
     * 下单时间
     */
    private Date orderCreateTime;

    /**
     * 下单人名称
     */
    private String orderCreateOperName;
    /**
     * 结算模式 2:撮合 1:贸易
     */
    private Integer modelSettle;
    /**
     * 验收人名字
     */
    private String inspOper;
    /**
     * 备注
     */
    private String remark;
    /**
     * 订单收货信息
     */
    private DycProEsIndexMappingOrderLogisticsRelationBO deliveryAddress;
    /**
     * 销售单三方信息
     */
    private DycProEsIndexMappingSaleStakeholderBO saleStakeholder;

    /**
     * 验收单明细
     */
    private List<DycProEsIndexMappingInspOrderItemBO> inspItemList;
    /**
     * 发票信息
     */
    private DycProEsIndexMappingInspInvoiceBO inspInvoice;
    /**
     * 采购方结算单状态
     */
    private Integer purFscOrderStatus;
    /**
     * 运营方结算单状态
     */
    private Integer oprFscOrderStatus;
    /**
     * 对账状态 0未对账 1对账一致 2对账不一致
     */
    private Integer checkState;
    /**
     * 结算单Id
     */
    private Long fscOrderId;
    /**
     * 预算id
     */
    private Long budgetId;
    /**
     * 预算名称
     */
    private String budgetName;
    /**
     * 采购需求编号
     */
    private String purchaseNeedNo;
}
