package com.tydic.dyc.pro.base.core.dictionary.enums;

/**
 * 店铺状态 枚举
 *
 * @author sunch
 */

public enum DmcShopMainShopStatus implements DictionaryEnum {
    DRAFT("DMC_SHOP_MAIN_SHOP_STATUS", "0", "草稿", "店铺状态"),
    PENDING_REVIEW("DMC_SHOP_MAIN_SHOP_STATUS", "1", "审批中", "店铺状态"),
    NOT_ACCEPTED("DMC_SHOP_MAIN_SHOP_STATUS", "2", "审批驳回", "店铺状态"),
    APPROVAL("DMC_SHOP_MAIN_SHOP_STATUS", "3", "审批通过", "店铺状态"),
    REJECTED("DMC_SHOP_MAIN_SHOP_STATUS", "4", "运营中", "店铺状态"),
    PENDING_EFFECTIVE("DMC_SHOP_MAIN_SHOP_STATUS", "5", "已冻结", "店铺状态");
    /**
     * 编码
     */
    private String dictionaryCode;
    /**
     * 编码
     */
    private String code;
    /**
     * 编码值
     */
    private String value;
    /**
     * 名称
     */
    private String dictionaryName;

    DmcShopMainShopStatus(String dictionaryCode, String code, String value, String dictionaryName) {
        this.dictionaryCode = dictionaryCode;
        this.code = code;
        this.value = value;
        this.dictionaryName = dictionaryName;
    }

    public String getDictionaryCode() {
        return dictionaryCode;
    }

    public String getDictionaryName() {
        return dictionaryName;
    }

    public String getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}
