package com.tydic.dyc.pro.base.core.dictionary.enums;

/**
 * 协议变更申请状态 枚举
 *
 * @author ZHOUYUYAN
 */

public enum DmcAgrChngApplyChngApplyStatus implements DictionaryEnum {
    DRAFT("DMC_AGR_CHNG_APPLY_CHNG_APPLY_STATUS", "0", "草稿", "协议变更申请状态"),
    APPROVAL("DMC_AGR_CHNG_APPLY_CHNG_APPLY_STATUS", "1", "审批中", "协议变更申请状态"),
    APPROVAL_PASS("DMC_AGR_CHNG_APPLY_CHNG_APPLY_STATUS", "2", "审批通过", "协议变更申请状态"),
    APPROVAL_REJECT("DMC_AGR_CHNG_APPLY_CHNG_APPLY_STATUS", "3", "审批驳回", "协议变更申请状态"),
    CONFIRMING("DMC_AGR_CHNG_APPLY_CHNG_APPLY_STATUS", "4", "确认中", "协议变更申请状态"),
    NOT_ACCEPTED("DMC_AGR_CHNG_APPLY_CHNG_APPLY_STATUS", "5", "未接受", "协议变更申请状态");
    /**
     * 编码
     */
    private String dictionaryCode;
    /**
     * 编码
     */
    private String code;
    /**
     * 编码值
     */
    private String value;
    /**
     * 名称
     */
    private String dictionaryName;

    DmcAgrChngApplyChngApplyStatus(String dictionaryCode, String code, String value, String dictionaryName) {
        this.dictionaryCode = dictionaryCode;
        this.code = code;
        this.value = value;
        this.dictionaryName = dictionaryName;
    }

    public String getDictionaryCode() {
        return dictionaryCode;
    }

    public String getDictionaryName() {
        return dictionaryName;
    }

    public String getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}
