package com.tydic.dyc.pro.base.core.dictionary.enums;

/**
 * 协议适用范围 枚举
 *
 * @author lihulin
 */

public enum DmcAgrMainPurScopeType implements DictionaryEnum {
    QPT("DMC_AGR_MAIN_PUR_SCOPE_TYPE", "0", "全平台", "协议适用范围"),
    QDW("DMC_AGR_MAIN_PUR_SCOPE_TYPE", "1", "全单位", "协议适用范围"),
    ZDDW("DMC_AGR_MAIN_PUR_SCOPE_TYPE", "2", "指定单位", "协议适用范围");
    /**
     * 编码
     */
    private String dictionaryCode;
    /**
     * 编码
     */
    private String code;
    /**
     * 编码值
     */
    private String value;
    /**
     * 名称
     */
    private String dictionaryName;

    DmcAgrMainPurScopeType(String dictionaryCode, String code, String value, String dictionaryName) {
        this.dictionaryCode = dictionaryCode;
        this.code = code;
        this.value = value;
        this.dictionaryName = dictionaryName;
    }

    public String getDictionaryCode() {
        return dictionaryCode;
    }

    public String getDictionaryName() {
        return dictionaryName;
    }

    public String getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}
