package com.tydic.dyc.pro.base.core.dictionary.enums;

/**
 * @description 商品池关联方式
 *   0：草稿
 * 	 1：待上架
 * 	 2：已上架
 * 	 3：已下架
 * 	 4：已失效
 * 	 5：合规校验失败
 * @author luoyou
 * @date 2025/04/24
 **/

public enum DmcCommSkuInfoSkuStatus implements DictionaryEnum{

    DRAFT("DMC_COMM_SKU_INFO_SKU_STATUS", "0","草稿", "商品状态"),
    TOBE_ON_SHELVES("DMC_COMM_SKU_INFO_SKU_STATUS", "1","待上架", "商品状态"),
    ON_SHELVES("DMC_COMM_SKU_INFO_SKU_STATUS", "2","已上架", "商品状态"),
    OFF_SHELVES("DMC_COMM_SKU_INFO_SKU_STATUS", "3","已下架", "商品状态"),
    DISABLE("DMC_COMM_SKU_INFO_SKU_STATUS", "4","失效", "商品状态"),
    BUSI_ERROR("DMC_COMM_SKU_INFO_SKU_STATUS", "5","合规校验失败", "商品状态"),
    FREEZE("DMC_COMM_SKU_INFO_SKU_STATUS", "6","冻结", "商品状态"),
    ;
    /**
     * 编码
     */
    private String dictionaryCode;
    /**
     * 编码
     */
    private String code;
    /**
     * 编码值
     */
    private String value;
    /**
     * 名称
     */
    private String dictionaryName;

    DmcCommSkuInfoSkuStatus(String dictionaryCode, String code, String value, String dictionaryName) {
        this.dictionaryCode = dictionaryCode;
        this.code = code;
        this.value = value;
        this.dictionaryName = dictionaryName;
    }
    public String getDictionaryCode() {
        return dictionaryCode;
    }

    public String getDictionaryName() {
        return dictionaryName;
    }

    public String getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}
