package com.tydic.dyc.pro.base.core.dictionary.enums;

/**
 * 标题：DmcSscConsultProductScopeType
 * 描述：协商单-商品适用范围类型
 */
public enum DmcSscConsultProductScopeType implements DictionaryEnum {

    ALL ("DMC_SSC_CONSULT_PRODUCT_SCOPE_TYPE", "1", "全平台", "商品适用范围类型"),
    ONLY ("DMC_SSC_CONSULT_PRODUCT_SCOPE_TYPE", "2", "仅本次采购", "商品适用范围类型");

    /**
     * 编码
     */
    private String dictionaryCode;
    /**
     * 编码
     */
    private String code;
    /**
     * 编码值
     */
    private String value;
    /**
     * 名称
     */
    private String dictionaryName;

    DmcSscConsultProductScopeType(String dictionaryCode, String code, String value, String dictionaryName) {
        this.dictionaryCode = dictionaryCode;
        this.code = code;
        this.value = value;
        this.dictionaryName = dictionaryName;
    }

    public String getDictionaryCode() {
        return dictionaryCode;
    }

    public String getDictionaryName() {
        return dictionaryName;
    }

    public String getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}
