package com.tydic.dyc.pro.base.core.dictionary.enums;

/**
 * 标题：DmcSscSupplyApplyInfoStatus
 * 描述：询价单状态
 */
public enum DmcSscConsultStatusYJ implements DictionaryEnum {

    DRAFT ("DMC_SSC_CONSULT_STATUS_YJ", "0", "草稿", "议价单状态"),
    UNDER_APPROVAL ("DMC_SSC_CONSULT_STATUS_YJ", "1", "审批中", "议价单状态"),
    APPROVAL_REJECTED("DMC_SSC_CONSULT_STATUS_YJ", "2", "审批驳回", "议价单状态"),
    TO_BE_PUBLISHED("DMC_SSC_CONSULT_STATUS_YJ", "3", "待发布", "议价单状态"),
    NOT_STARTED("DMC_SSC_CONSULT_STATUS_YJ", "4", "未开始", "议价单状态"),
    QUOTING("DMC_SSC_CONSULT_STATUS_YJ", "5", "报价中", "议价单状态"),
    AWAITING_RESULT_CONFIRMATION("DMC_SSC_CONSULT_STATUS_YJ", "6", "已报价", "议价单状态"),
    QUOTATION_APPROVAL_PROCESSING("DMC_SSC_CONSULT_STATUS_YJ", "7", "询价结果审批中", "议价单状态"),
    QUOTATION_APPROVAL_REJECTED("DMC_SSC_CONSULT_STATUS_YJ", "9", "询价结果审批驳回", "议价单状态"),
    RESULT_PENDING_PUBLICATION("DMC_SSC_CONSULT_STATUS_YJ", "10", "结果待发布", "议价单状态"),
    COMPLETED("DMC_SSC_CONSULT_STATUS_YJ", "11", "已下单", "议价单状态"),
    QUOTATION_TERMINATED("DMC_SSC_CONSULT_STATUS_YJ", "12", "已终止", "议价单状态"),
    FAIL("DMC_SSC_CONSULT_STATUS_YJ", "13", "询价失败", "议价单状态"),
    QUOTATION_DEADLINE("DMC_SSC_CONSULT_STATUS_YJ", "8", "报价截止", "议价单状态"),
    BE_SELECTED("DMC_SSC_CONSULT_STATUS_YJ", "100", "已中标", "议价单状态"),
    NOT_BE_SELECTED("DMC_SSC_CONSULT_STATUS_YJ", "101", "未中标", "议价单状态");

    /**
     * 编码
     */
    private String dictionaryCode;
    /**
     * 编码
     */
    private String code;
    /**
     * 编码值
     */
    private String value;
    /**
     * 名称
     */
    private String dictionaryName;

    DmcSscConsultStatusYJ(String dictionaryCode, String code, String value, String dictionaryName) {
        this.dictionaryCode = dictionaryCode;
        this.code = code;
        this.value = value;
        this.dictionaryName = dictionaryName;
    }

    public String getDictionaryCode() {
        return dictionaryCode;
    }

    public String getDictionaryName() {
        return dictionaryName;
    }

    public String getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}
