package com.tydic.dyc.pro.base.core.dictionary.enums;

/**
 * @author lihulin
 * @description 处理结果:
 * 通过：PASS
 * 驳回：REJECT
 * 转交：TRANSF
 * @date 2025/05/14
 **/

public enum PublicProcInstDealResult implements DictionaryEnum {
    /**
     * 通过：PASS
     */
    PASS("PUBLIC_PROC_INST_DEAL_RESULT", "pass", "审批通过", "流程单据处理结果"),
    /**
     * 驳回：REJECT
     */
    REJECT("PUBLIC_PROC_INST_DEAL_RESULT", "reject", "审批驳回", "流程单据处理结果"),
    /**
     * 转交：TRANSF
     */
    TRANSF("PUBLIC_PROC_INST_DEAL_RESULT", "TRANSF", "转交", "流程单据处理结果");
    /**
     * 编码
     */
    private final String dictionaryCode;
    /**
     * 编码
     */
    private final String code;
    /**
     * 编码值
     */
    private final String value;
    /**
     * 名称
     */
    private final String dictionaryName;

    PublicProcInstDealResult(String dictionaryCode, String code, String value, String dictionaryName) {
        this.dictionaryCode = dictionaryCode;
        this.code = code;
        this.value = value;
        this.dictionaryName = dictionaryName;
    }

    public String getDictionaryCode() {
        return dictionaryCode;
    }

    public String getDictionaryName() {
        return dictionaryName;
    }

    public String getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}
