package com.tydic.dyc.pro.base.core.encode.service.impl;


import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.dyc.pro.base.common.mybatis.LambdaQueryWrapperX;
import com.tydic.dyc.pro.base.core.constant.DycProCoreRspConstant;
import com.tydic.dyc.pro.base.core.dao.SysSerialRuleMapper;
import com.tydic.dyc.pro.base.core.encode.service.api.DycProEncodeSerialRuleMaintenanceService;
import com.tydic.dyc.pro.base.core.encode.service.bo.*;
import com.tydic.dyc.pro.base.core.po.SysSerialRulePO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.Set;

/**
 * 描述：EncodeSerialRuleMaintenanceServiceImpl
 *
 * @author luoyou
 * @date 2025/5/19 11:19
 */

@HTServiceImpl
public class DycProEncodeSerialRuleMaintenanceServiceImpl implements DycProEncodeSerialRuleMaintenanceService {

	@Autowired
	private SysSerialRuleMapper sysSerialRuleMapper;
	@Autowired
	private CacheClient cacheClient;


	/**
	 * 实例前缀连接符
	 */
	private static final String PREFIX_INSTANCE = "PK_ENCODE_INSTANCE";

	/**
	 * 规则前缀连接符
	 */
	private static final String PREFIX_RULE = "PK_ENCODE_RULE";
	/**
	 * 下划线连接符
	 */
	private static final String CONNECTOR_UNDERLINE = "_";

	@Override
	public DycProEncodeSerialRuleMaintenanceRspBO dealEncodeRule(DycProEncodeSerialRuleMaintenanceReqBO reqBO) {


		val(reqBO);

		SysSerialRulePO sysSerialRulePO = sysSerialRuleMapper.selectOne(new LambdaQueryWrapperX<SysSerialRulePO>().eq(SysSerialRulePO::getEncodeRuleCode, reqBO.getEncodeRuleCode()));
		if(null == sysSerialRulePO){
			SysSerialRulePO insertSerialRulePO = JSON.parseObject(JSON.toJSONString(reqBO), SysSerialRulePO.class);
			sysSerialRuleMapper.insert(insertSerialRulePO);
		} else {

			SysSerialRulePO updateSerialRulePO = JSON.parseObject(JSON.toJSONString(reqBO), SysSerialRulePO.class);
			updateSerialRulePO.setEncodeRuleId(sysSerialRulePO.getEncodeRuleId());
			sysSerialRuleMapper.updateById(updateSerialRulePO);
		}


		DycProEncodeSerialRuleBO ruleByDb = getRuleByDb(reqBO);

		String encodeSerialRuleKey = PREFIX_RULE + CONNECTOR_UNDERLINE + ruleByDb.getCenterCode() + CONNECTOR_UNDERLINE + ruleByDb.getEncodeRuleCode() + CONNECTOR_UNDERLINE;
		String encodeSerialInstanceKey = PREFIX_INSTANCE + CONNECTOR_UNDERLINE + ruleByDb.getCenterCode() + CONNECTOR_UNDERLINE + ruleByDb.getEncodeRuleCode() + CONNECTOR_UNDERLINE;

		clearKey(encodeSerialRuleKey);
		clearKey(encodeSerialInstanceKey);


		//编码规则放到redis
		cacheClient.set(encodeSerialRuleKey, JSON.toJSONString(ruleByDb));

		DycProEncodeSerialRuleMaintenanceRspBO rspBO = new DycProEncodeSerialRuleMaintenanceRspBO();
		rspBO.setRespCode(DycProCoreRspConstant.RSP_CODE_SUCCEED);
		rspBO.setRespDesc(DycProCoreRspConstant.RSP_DESC_SUCCEED);
		return rspBO;
	}

	private void val(DycProEncodeSerialRuleMaintenanceReqBO reqBO) {
		if(StringUtils.isBlank(reqBO.getEncodeRuleCode())){
			throw new ZTBusinessException("规则编码不能为空");
		}
	}


	private void clearKey(String ruleKey) {
		Set<String> keys = cacheClient.getkeys(ruleKey + "*");
		if (!CollectionUtils.isEmpty(keys)) {
			for (String key : keys) {
				cacheClient.delete(key);
			}
		}
	}


	private DycProEncodeSerialRuleBO getRuleByDb(DycProEncodeSerialRuleMaintenanceReqBO reqBO) {
		LambdaQueryWrapperX<SysSerialRulePO> serialRuleQueryWrapper = new LambdaQueryWrapperX<>();
		serialRuleQueryWrapper.eq(SysSerialRulePO::getEncodeRuleCode, reqBO.getEncodeRuleCode());
		SysSerialRulePO serialRulePO = sysSerialRuleMapper.selectOne(serialRuleQueryWrapper);
		if(null == serialRulePO){
			throw new ZTBusinessException("没有配置编码规则");
		}
		return JSON.parseObject(JSON.toJSONString(serialRulePO), DycProEncodeSerialRuleBO.class);
	}
}
