package com.tydic.dyc.pro.base.core.flow.repository.dto;

import lombok.Data;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 描述：流程实例DTO
 * @author yuhao
 * @date 2025-04-17 17:47
 **/
@Data
public class DycProPublicProcInstDTO implements Serializable {
    private static final long serialVersionUID = 4947055281092468987L;
    /**
     * 单据id
     */
    private Long dataId;
    /**
     * 单据编码
     */
    private String dataCode;
    /**
     * 单据名称
     */
    private String dataName;
    /**
     * 单据备注
     */
    private String dataRemark;
    /**
     * 单据状态:
     * 1：审批中
     * 2：已通过
     * 3：已驳回
     */
    private Integer dataStatus;
    /**
     * 业务类型
     */
    private String busiType;
    /**
     * 单据申请人id
     */
    private Long createUserId;
    /**
     * 单据申请人名称
     */
    private String createUserName;
    /**
     * 单据申请人机构id
     */
    private Long createUserOrgId;
    /**
     * 单据申请人机构名称
     */
    private String createUserOrgName;
    /**
     * 单据申请人公司id
     */
    private Long createUserCompanyId;
    /**
     * 单据申请人公司名称
     */
    private String createUserCompanyName;
    /**
     * 单据申请人机构树
     */
    private String createUserOrgPath;
    /**
     * 所属中心:
     AGR：协议
     UOC：订单
     UMC：会员
     FSC：结算
     UCC：商品

     */
    private String centerCode;
    /**
     * 流程实例id
     */
    private String procInstId;
    /**
     * 流程定义key
     */
    private String procDefKey;
    /**
     * 流程名称
     */
    private String procName;
    /**
     * 流程类型:
     业务流：BUSINESS;
     审批流：APPROVE
     */
    private String procType;
    /**
     * 业务对象id
     */
    private Long objId;
    /**
     * 业务对象类型:
     订单相关单据：10打头，后面加2位数字编码，如10XX；
     商品相关单据：20打头，后面加2位数字编码，如20XX；
     协议相关单据：30打头，后面加2位数字编码，如30XX；
     会员相关单据：40打头，后面加2位数字编码，如40XX；
     结算相关单据：50打头，后面加2位数字编码，如50XX；

     */
    private String objType;
    /**
     * 流程创建时间
     */
    private Date createTime;
    /**
     * 流程完结标志：
     0：未完结
     1：已完结;
     2：已取消
     */
    private Integer finishTag;
    /**
     * 流程完成时间
     */
    private Date finishTime;
    /**
     * 删除标志：0:未删除；1已删除
     */
    private Integer delFlag;
    /**
     * 任务集合
     */
    private List<DycProPublicTaskInstDTO> taskList;
}
