package com.tydic.dyc.pro.base.core.po;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 描述：流程任务实例对象
 * @author yuhao
 * @date 2025-04-17 17:47
 **/
@Data
@TableName("PUBLIC_PROC_TASK_INST")
public class PublicProcTaskInstPO implements Serializable {

	private static final long serialVersionUID = 6644124232519697587L;

	/**
	 * 数据id
	 */
	@TableField(value = "DATA_ID")
	@TableId
    private Long dataId;
	/**
	 * 所属中心:
            AGR：协议
            UOC：订单
            UMC：会员
            FSC：结算
            UCC：商品
            
	 */
	@TableField(value = "CENTER_CODE")
    private String centerCode;
	/**
	 * 任务实例id
	 */
	@TableField(value = "TASK_INST_ID")
    private String taskInstId;
	/**
	 * 流程实例id
	 */
	@TableField(value = "PROC_INST_ID")
    private String procInstId;
	/**
	 * 流程定义key
	 */
	@TableField(value = "PROC_DEF_KEY")
    private String procDefKey;
	/**
	 * 流程类型:
            业务流：BUSINESS;
            审批流：APPROVE
	 */
	@TableField(value = "PROC_TYPE")
    private String procType;
	/**
	 * 业务单据id
	 */
	@TableField(value = "OBJ_ID")
    private Long objId;
	/**
	 * 业务单据类型:
            订单相关单据：10打头，后面加2位数字编码，如10XX；
            商品相关单据：20打头，后面加2位数字编码，如20XX；
            协议相关单据：30打头，后面加2位数字编码，如30XX；
            会员相关单据：40打头，后面加2位数字编码，如40XX；
            结算相关单据：50打头，后面加2位数字编码，如50XX；
            
	 */
	@TableField(value = "OBJ_TYPE")
    private String objType;
	/**
	 * 任务标识
             0 ：正常任务；
            1：前加签任务  
            2：后加签任务  
            3：转签任务
	 */
	@TableField(value = "TASK_SIGN_TAG")
    private Integer taskSignTag;
	/**
	 * 环节编码
	 */
	@TableField(value = "STEP_CODE")
    private String stepCode;
	/**
	 * 环节名称
	 */
	@TableField(value = "STEP_NAME")
    private String stepName;
	/**
	 * 任务创建时间
	 */
	@TableField(value = "CREATE_TIME")
    private Date createTime;
	/**
	 * 任务更新时间
	 */
	@TableField(value = "UPDATE_TIME")
    private Date updateTime;
	/**
	 * 任务待办人id
	 */
	@TableField(value = "TASK_USER_ID")
    private Long taskUserId;
	/**
	 * 任务待办人名称
	 */
	@TableField(value = "TASK_USER_NAME")
    private String taskUserName;
	/**
	 * 任务待办人机构id
	 */
	@TableField(value = "TASK_USER_ORG_ID")
    private Long taskUserOrgId;
	/**
	 * 任务待办人机构名称
	 */
	@TableField(value = "TASK_USER_ORG_NAME")
    private String taskUserOrgName;
	/**
	 * 任务待办人公司id
	 */
	@TableField(value = "TASK_USER_COMPANY_ID")
    private Long taskUserCompanyId;
	/**
	 * 任务待办人公司名称
	 */
	@TableField(value = "TASK_USER_COMPANY_NAME")
    private String taskUserCompanyName;
	/**
	 * 任务待办人机构树
	 */
	@TableField(value = "TASK_USER_ORG_PATH")
    private String taskUserOrgPath;
	/**
	 * 完结标志:
            0：未完结
            1：已完结
            2：已取消
	 */
	@TableField(value = "FINISH_TAG")
    private Integer finishTag;
	/**
	 * 完成时间
	 */
	@TableField(value = "FINISH_TIME")
    private Date finishTime;
	/**
	 * 任务处理人ID
	 */
	@TableField(value = "DEAL_USER_ID")
    private Long dealUserId;
	/**
	 * 任务处理人名称
	 */
	@TableField(value = "DEAL_USER_NAME")
    private String dealUserName;
	/**
	 * 任务处理人机构id
	 */
	@TableField(value = "DEAL_USER_ORG_ID")
    private Long dealUserOrgId;
	/**
	 * 任务处理人机构名称
	 */
	@TableField(value = "DEAL_USER_ORG_NAME")
    private String dealUserOrgName;
	/**
	 * 任务处理人公司id
	 */
	@TableField(value = "DEAL_USER_COMPANY_ID")
    private Long dealUserCompanyId;
	/**
	 * 任务处理人公司名称
	 */
	@TableField(value = "DEAL_USER_COMPANY_NAME")
    private String dealUserCompanyName;
	/**
	 * 任务处理人机构树
	 */
	@TableField(value = "DEAL_USER_ORG_PATH")
    private String dealUserOrgPath;
	/**
	 * 处理结果:
            通过：PASS
            驳回：REJECT
	 		转交：TRANSFER
	 */
	@TableField(value = "DEAL_RESULT")
    private String dealResult;
	/**
	 * 处理备注
	 */
	@TableField(value = "DEAL_REMARK")
    private String dealRemark;
	/**
	 * 删除标志：0:未删除；1已删除
	 */
	@TableField(value = "DEL_FLAG")
    private Integer delFlag;
}