package com.tydic.dyc.pro.base.core.po;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 标题:SerialRuleDTO
 * 说明:编码规则配置
 * 时间:2025/4/16 19:03
 * 作者:罗有
 */

@TableName("SYS_SERIAL_RULE")
@Data
public class SysSerialRulePO implements Serializable {

	private static final long serialVersionUID = 8239937292823060284L;
	/**
	 * 主键ID
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@TableField(value = "ENCODE_RULE_ID")
	private Long encodeRuleId;
	/**
	 * 所属模块
	 */
	@TableField(value = "CENTER_CODE")
	private String centerCode;
	/**
	 * 编码规则编码 唯一 格式:表名_字段名 ,同表同字段要区分业务则拼接“_业务类型枚举”
	 */
	@TableField(value = "ENCODE_RULE_CODE")
	private String encodeRuleCode;
	/**
	 * 编码规则名称
	 */
	@TableField(value = "ENCODE_RULE_NAME")
	private String encodeRuleName;
	/**
	 * 是否允许前台修改 1是 0否
	 */
	@TableField(value = "PAGE_CHANGE_FLAG")
	private Integer pageChangeFlag;
	/**
	 * 前缀
	 */
	@TableField(value = "PREFIX")
	private String prefix;
	/**
	 * 一级链接符
	 */
	@TableField(value = "FIRST_CONNECT_SYMBOL")
	private String firstConnectSymbol;
	/**
	 * 日期 格式:yyyyMMdd 支持java的日期转换格式
	 */
	@TableField(value = "DATE_INFIX")
	private String dateInfix;
	/**
	 * 二级链接符
	 */
	@TableField(value = "SECOND_CONNECT_SYMBOL")
	private String secondConnectSymbol;
	/**
	 * 序列号位数
	 */
	@TableField(value = "SERIAL_NUM")
	private Long serialNum;
	/**
	 * 步长
	 */
	@TableField(value = "STEP_RANGE")
	private Long stepRange;
	/**
	 * 规则顺序 格式:1-2-3-4-5 1:前缀 2:一级连接符 3:日期 4:二级连接符 5:序列号
	 */
	@TableField(value = "RULE_ORDER")
	private String ruleOrder;
	/**
	 * 创建人ID
	 */
	@TableField(value = "CREATE_USER_ID")
	private Long createUserId;
	/**
	 * 创建人名称
	 */
	@TableField(value = "CREATE_USER_NAME")
	private String createUserName;
	/**
	 * 创建人账号
	 */
	@TableField(value = "CREATE_USER_ACCOUNT")
	private String createUserAccount;
	/**
	 * 创建人机构ID
	 */
	@TableField(value = "CREATE_ORG_ID")
	private Long createOrgId;
	/**
	 * 创建人机构名称
	 */
	@TableField(value = "CREATE_ORG_NAME")
	private String createOrgName;
	/**
	 * 创建人机构树路径
	 */
	@TableField(value = "CREATE_ORG_PATH")
	private String createOrgPath;
	/**
	 * 创建人公司ID
	 */
	@TableField(value = "CREATE_COMPANY_ID")
	private Long createCompanyId;
	/**
	 * 创建人公司名称
	 */
	@TableField(value = "CREATE_COMPANY_NAME")
	private String createCompanyName;
	/**
	 * 创建时间
	 */
	@TableField(value = "CREATE_TIME")
	private Date createTime;
	/**
	 * 更新人ID
	 */
	@TableField(value = "UPDATE_USER_ID")
	private Long updateUserId;
	/**
	 * 更新人名称
	 */
	@TableField(value = "UPDATE_USER_NAME")
	private String updateUserName;
	/**
	 * 更新人账号
	 */
	@TableField(value = "UPDATE_USER_ACCOUNT")
	private String updateUserAccount;
	/**
	 * 更新人机构ID
	 */
	@TableField(value = "UPDATE_ORG_ID")
	private Long updateOrgId;
	/**
	 * 更新人机构名称
	 */
	@TableField(value = "UPDATE_ORG_NAME")
	private String updateOrgName;
	/**
	 * 更新人机构树路径
	 */
	@TableField(value = "UPDATE_ORG_PATH")
	private String updateOrgPath;
	/**
	 * 更新人公司ID
	 */
	@TableField(value = "UPDATE_COMPANY_ID")
	private Long updateCompanyId;
	/**
	 * 更新人公司名称
	 */
	@TableField(value = "UPDATE_COMPANY_NAME")
	private String updateCompanyName;
	/**
	 * 更新时间
	 */
	@TableField(value = "UPDATE_TIME")
	private Date updateTime;

}
