/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.base.core.encode.service;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.dyc.pro.base.common.mybatis.LambdaQueryWrapperX;
import com.tydic.dyc.pro.base.core.dao.SysSerialRuleMapper;
import com.tydic.dyc.pro.base.core.encode.service.api.DycProEncodeSerialRuleMaintenanceService;
import com.tydic.dyc.pro.base.core.encode.service.bo.DycProEncodeSerialRuleBO;
import com.tydic.dyc.pro.base.core.encode.service.bo.DycProEncodeSerialRuleMaintenanceReqBO;
import com.tydic.dyc.pro.base.core.encode.service.bo.DycProEncodeSerialRuleMaintenanceRspBO;
import com.tydic.dyc.pro.base.core.po.SysSerialRulePO;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.base.core.encode.service.api.DycProEncodeSerialRuleMaintenanceService"})
public class DycProEncodeSerialRuleMaintenanceServiceImpl
implements DycProEncodeSerialRuleMaintenanceService {
    @Autowired
    private SysSerialRuleMapper sysSerialRuleMapper;
    @Autowired
    private CacheClient cacheClient;
    private static final String PREFIX_INSTANCE = "PK_ENCODE_INSTANCE";
    private static final String PREFIX_RULE = "PK_ENCODE_RULE";
    private static final String CONNECTOR_UNDERLINE = "_";

    @Override
    @PostMapping(value={"dealEncodeRule"})
    public DycProEncodeSerialRuleMaintenanceRspBO dealEncodeRule(@RequestBody DycProEncodeSerialRuleMaintenanceReqBO reqBO) {
        this.val(reqBO);
        SysSerialRulePO sysSerialRulePO = (SysSerialRulePO)this.sysSerialRuleMapper.selectOne((Wrapper)new LambdaQueryWrapperX().eq(SysSerialRulePO::getEncodeRuleCode, (Object)reqBO.getEncodeRuleCode()));
        if (null == sysSerialRulePO) {
            SysSerialRulePO insertSerialRulePO = (SysSerialRulePO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), SysSerialRulePO.class);
            this.sysSerialRuleMapper.insert(insertSerialRulePO);
        } else {
            SysSerialRulePO updateSerialRulePO = (SysSerialRulePO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), SysSerialRulePO.class);
            updateSerialRulePO.setEncodeRuleId(sysSerialRulePO.getEncodeRuleId());
            this.sysSerialRuleMapper.updateById(updateSerialRulePO);
        }
        DycProEncodeSerialRuleBO ruleByDb = this.getRuleByDb(reqBO);
        String encodeSerialRuleKey = "PK_ENCODE_RULE_" + ruleByDb.getCenterCode() + CONNECTOR_UNDERLINE + ruleByDb.getEncodeRuleCode() + CONNECTOR_UNDERLINE;
        String encodeSerialInstanceKey = "PK_ENCODE_INSTANCE_" + ruleByDb.getCenterCode() + CONNECTOR_UNDERLINE + ruleByDb.getEncodeRuleCode() + CONNECTOR_UNDERLINE;
        this.clearKey(encodeSerialRuleKey);
        this.clearKey(encodeSerialInstanceKey);
        this.cacheClient.set("{encode}" + encodeSerialRuleKey, (Object)JSON.toJSONString((Object)ruleByDb));
        DycProEncodeSerialRuleMaintenanceRspBO rspBO = new DycProEncodeSerialRuleMaintenanceRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void val(DycProEncodeSerialRuleMaintenanceReqBO reqBO) {
        if (StringUtils.isBlank((CharSequence)reqBO.getEncodeRuleCode())) {
            throw new ZTBusinessException("\u89c4\u5219\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void clearKey(String ruleKey) {
        Set keys = this.cacheClient.getkeys("{encode}" + ruleKey + "*");
        if (!CollectionUtils.isEmpty((Collection)keys)) {
            for (String key : keys) {
                this.cacheClient.delete(key);
            }
        }
    }

    private DycProEncodeSerialRuleBO getRuleByDb(DycProEncodeSerialRuleMaintenanceReqBO reqBO) {
        LambdaQueryWrapperX serialRuleQueryWrapper = new LambdaQueryWrapperX();
        serialRuleQueryWrapper.eq(SysSerialRulePO::getEncodeRuleCode, (Object)reqBO.getEncodeRuleCode());
        SysSerialRulePO serialRulePO = (SysSerialRulePO)this.sysSerialRuleMapper.selectOne((Wrapper)serialRuleQueryWrapper);
        if (null == serialRulePO) {
            throw new ZTBusinessException("\u6ca1\u6709\u914d\u7f6e\u7f16\u7801\u89c4\u5219");
        }
        return (DycProEncodeSerialRuleBO)JSON.parseObject((String)JSON.toJSONString((Object)serialRulePO), DycProEncodeSerialRuleBO.class);
    }
}

