package com.tydic.dyc.pro.base.core.dictionary.enums;

/**
 * @author lihulin
 * @description sku售后支持天数
 * @date 2025/05/14
 **/

public enum DmcCommSkuAfterSaleInfoTimeLimit implements DictionaryEnum {
    /**
     * 7天
     */
    SEVEN("DMC_COMM_SKU_AFTER_SALE_INFO_TIME_LIMIT", "7", "7天", "sku售后支持天数"),
    /**
     * 15天
     */
    FIFTEEN("DMC_COMM_SKU_AFTER_SALE_INFO_TIME_LIMIT", "15", "15天", "sku售后支持天数"),
    /**
     * 20天
     */
    TWENTY("DMC_COMM_SKU_AFTER_SALE_INFO_TIME_LIMIT", "20", "20天", "sku售后支持天数");
    /**
     * 编码
     */
    private String dictionaryCode;
    /**
     * 编码
     */
    private String code;
    /**
     * 编码值
     */
    private String value;
    /**
     * 名称
     */
    private String dictionaryName;

    DmcCommSkuAfterSaleInfoTimeLimit(String dictionaryCode, String code, String value, String dictionaryName) {
        this.dictionaryCode = dictionaryCode;
        this.code = code;
        this.value = value;
        this.dictionaryName = dictionaryName;
    }

    public String getDictionaryCode() {
        return dictionaryCode;
    }

    public String getDictionaryName() {
        return dictionaryName;
    }

    public String getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}
