package com.tydic.dyc.pro.base.core.dictionary.enums;

/**
 * @description 商品核验状态
 * @author luoyou
 * @date 2025/04/24
 **/

public enum DmcCommSkuInfoExamineStatus implements DictionaryEnum {


    /**
     * 检测状态:
     1:待核验
     2:核验中
     3:核验通过
     4:核验不通过
     */

    TO_CHECK("DMC_COMM_SKU_INFO_EXAMINE_STATUS", "1","待核验", "核验状态"),
    CHECKING("DMC_COMM_SKU_INFO_EXAMINE_STATUS", "2","核验中", "核验状态"),
    CHECK_PASS("DMC_COMM_SKU_INFO_EXAMINE_STATUS", "3","核验通过", "核验状态"),
    CHECK_WORN_PASS("DMC_COMM_SKU_INFO_EXAMINE_STATUS", "4","核验预警通过", "核验状态"),
    CHECK_REJECT("DMC_COMM_SKU_INFO_EXAMINE_STATUS", "5","核验不通过", "核验状态"),
            ;
    /**
     * 编码
     */
    private String dictionaryCode;
    /**
     * 编码
     */
    private String code;
    /**
     * 编码值
     */
    private String value;
    /**
     * 名称
     */
    private String dictionaryName;

    DmcCommSkuInfoExamineStatus(String dictionaryCode, String code, String value, String dictionaryName) {
        this.dictionaryCode = dictionaryCode;
        this.code = code;
        this.value = value;
        this.dictionaryName = dictionaryName;
    }
    public String getDictionaryCode() {
        return dictionaryCode;
    }

    public String getDictionaryName() {
        return dictionaryName;
    }

    public String getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}
