package com.tydic.dyc.pro.base.core.dictionary.enums;
/**
 * @description 发货单状态举值
 * @author Luokan
 * @date 2025/04/16
 **/
public enum EgcShipOrderShipOrderState implements DictionaryEnum{
    /**
     * 已发货
     */
    FH_FH_FH("SHIP_ORDER_STATE","FH_FH_FH","已发货", "发货单状态"),
    /**
     * 已到货
     */
    FH_FH_YDH("SHIP_ORDER_STATE","FH_FH_YDH","已到货", "发货单状态"),
    /**
     * 已拒收
     */
    FH_FH_JS("SHIP_ORDER_STATE","FH_FH_JS","已拒收", "发货单状态"),
    /**
     * 已验收
     */
    FH_FH_YS("SHIP_ORDER_STATE","FH_FH_YS","已验收", "发货单状态");
    /**
     * 编码
     */
    private String dictionaryCode;
    /**
     * 编码
     */
    private String code;
    /**
     * 编码值
     */
    private String value;
    /**
     * 名称
     */
    private String dictionaryName;

    EgcShipOrderShipOrderState(String dictionaryCode, String code, String value, String dictionaryName) {
        this.dictionaryCode = dictionaryCode;
        this.code = code;
        this.value = value;
        this.dictionaryName = dictionaryName;
    }
    public String getDictionaryCode() {
        return dictionaryCode;
    }

    public String getDictionaryName() {
        return dictionaryName;
    }

    public String getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}
