package com.tydic.dyc.pro.base.core.dictionary.enums;

/**
 * @author lihulin
 * @description 流程单据业务类型
 * @date 2025/05/14
 **/

public enum PublicProcInstBusiType implements DictionaryEnum {
    /**
     * 协议商品上架审批
     */
    AGR_SKU_ON_SHELVES_APPROVE("PUBLIC_PROC_INST_BUSI_TYPE", "AgrSkuOnShelvesApprove", "协议商品上架审批", "流程单据业务类型"),
    /**
     * 协议商品下架审批
     */
    AGR_SKU_OFF_SHELVES_APPROVE("PUBLIC_PROC_INST_BUSI_TYPE", "AgrSkuOffShelvesApprove", "协议商品下架审批", "流程单据业务类型"),
    /**
     * 协议商品编辑审批
     */
    AGR_SKU_EDIT_APPROVE("PUBLIC_PROC_INST_BUSI_TYPE", "AgrSkuEditApprove", "协议商品编辑审批", "流程单据业务类型"),
    /**
     * 电商商品上架审批
     */
    ESKU_ON_SHELVES_APPROVE("PUBLIC_PROC_INST_BUSI_TYPE", "ESkuOnShelvesApprove", "电商商品上架审批", "流程单据业务类型"),
    /**
     * 电商商品下架审批
     */
    ESKU_OFF_SHELVES_APPROVE("PUBLIC_PROC_INST_BUSI_TYPE", "ESkuOffShelvesApprove", "电商商品下架审批", "流程单据业务类型"),
    /**
     * 店铺创建审批
     */
    SHOP_CREATE_APPROVE("PUBLIC_PROC_INST_BUSI_TYPE", "ShopCreateApprove", "店铺创建审批", "流程单据业务类型"),
    /**
     * 店铺变更审批
     */
    SHOP_CHANGE_APPROVE("PUBLIC_PROC_INST_BUSI_TYPE", "ShopChangeApprove", "店铺变更审批", "流程单据业务类型"),
    /**
     * 协议创建审批
     */
    AGR_CREATE_APPROVE("PUBLIC_PROC_INST_BUSI_TYPE", "AgrCreateApprove", "协议创建审批", "流程单据业务类型"),
    /**
     * 协议变更审批
     */
    AGR_CHANGE_APPROVE("PUBLIC_PROC_INST_BUSI_TYPE", "AgrChangeApprove", "协议变更审批", "流程单据业务类型"),
    /**
     * 寻源单创建审批
     */
    CONSULT_INQUIRY_APPROVE("PUBLIC_PROC_INST_BUSI_TYPE", "InquiryCreateApprove", "寻源单审批", "流程单据业务类型"),
    /**
     * 寻源结果审批
     */
    CONSULT_INQUIRY_RESULT_APPROVE("PUBLIC_PROC_INST_BUSI_TYPE", "InquiryResultApprove", "寻源结果审批", "流程单据业务类型"),
    /**
     * 供货申请创建审批
     */
    SUPPLY_APPLY_APPROVE("PUBLIC_PROC_INST_BUSI_TYPE", "SupplyApplyApprove", "供货申请创建审批", "流程单据业务类型"),
    /**
     * 竞价创建审批
     */
    CONSULT_BIDDING_APPROVE("PUBLIC_PROC_INST_BUSI_TYPE", "BiddingCreateApprove", "竞价单审批", "流程单据业务类型"),
    /**
     * 竞价结果审批
     */
    CONSULT_BIDDING_RESULT_APPROVE("PUBLIC_PROC_INST_BUSI_TYPE", "BiddingResultApprove", "竞价结果审批", "流程单据业务类型"),
    /**
     * 预算审批
     */
    BUDGET_APPROVE("PUBLIC_PROC_INST_BUSI_TYPE", "BudgetApprove", "预算审批", "流程单据业务类型"),
    /**
     * 订单审批
     */
    ORDER_CREATE_APPROVE("PUBLIC_PROC_INST_BUSI_TYPE", "OrderCreateApprove", "订单审批", "流程单据业务类型");
    /**
     * 编码
     */
    private final String dictionaryCode;
    /**
     * 编码
     */
    private final String code;
    /**
     * 编码值
     */
    private final String value;
    /**
     * 名称
     */
    private final String dictionaryName;

    PublicProcInstBusiType(String dictionaryCode, String code, String value, String dictionaryName) {
        this.dictionaryCode = dictionaryCode;
        this.code = code;
        this.value = value;
        this.dictionaryName = dictionaryName;
    }

    public String getDictionaryCode() {
        return dictionaryCode;
    }

    public String getDictionaryName() {
        return dictionaryName;
    }

    public String getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}
