package com.tydic.dyc.pro.base.core.flow.repository.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.base.core.dao.PublicProcInstMapper;
import com.tydic.dyc.pro.base.core.dao.PublicProcTaskInstMapper;
import com.tydic.dyc.pro.base.core.flow.repository.api.DycProPublicProcInstRepository;
import com.tydic.dyc.pro.base.core.flow.repository.constants.DycProCommonFlowConstant;
import com.tydic.dyc.pro.base.core.flow.repository.dto.DycProPublicProcInstDTO;
import com.tydic.dyc.pro.base.core.po.PublicProcInstPO;
import com.tydic.dyc.pro.base.core.po.PublicProcTaskInstPO;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

/**
 * @Author yuhao
 * @Date 2025/4/21 15:56
 * @Description:
 **/
@Service
public class DycProPublicProcInstRepositoryImpl implements DycProPublicProcInstRepository {
    @Autowired
    private PublicProcInstMapper publicProcInstMapper;

    @Autowired
    private PublicProcTaskInstMapper publicProcTaskInstMapper;

    @Override
    public DycProPublicProcInstDTO queryFlowMainByObjLastOne(DycProPublicProcInstDTO flowProcInstDto) {
        PublicProcInstPO publicProcInstPO = this.publicProcInstMapper.selectOne(Wrappers.<PublicProcInstPO>lambdaQuery()
                .eq(null != flowProcInstDto.getObjId(), PublicProcInstPO::getObjId, flowProcInstDto.getObjId())
                .eq(StringUtils.isNotBlank(flowProcInstDto.getBusiType()), PublicProcInstPO::getBusiType, flowProcInstDto.getBusiType())
                .eq(StringUtils.isNotBlank(flowProcInstDto.getObjType()), PublicProcInstPO::getObjType, flowProcInstDto.getObjType())
                .eq(null != flowProcInstDto.getFinishTag(),PublicProcInstPO::getFinishTag,flowProcInstDto.getFinishTag())
                .orderByDesc(PublicProcInstPO::getCreateTime).last("limit 1"));
        if(null == publicProcInstPO){
            return null;
        }else{
            DycProPublicProcInstDTO dycProPublicProcInstDTO = new DycProPublicProcInstDTO();
            BeanUtils.copyProperties(publicProcInstPO,dycProPublicProcInstDTO);
            return dycProPublicProcInstDTO;
        }
    }

    /**
     * 流程终止
     */
    @Override
    public void cancelFlow(DycProPublicProcInstDTO flowProcInstDto) {

        //参数校验
        this.cancelFlowParamVerify(flowProcInstDto);

        //查询流程实例数据
        PublicProcInstPO procInstPO = this.publicProcInstMapper.selectOne(Wrappers.<PublicProcInstPO>lambdaQuery()
                .eq(PublicProcInstPO::getProcInstId, flowProcInstDto.getProcInstId())
                .eq(PublicProcInstPO::getFinishTag, DycProCommonFlowConstant.FinishTag.FINISH_TAG_NOT_FINISH)
                .eq(PublicProcInstPO::getDelFlag, DycProCommonFlowConstant.DelFlag.DEL_FLAG_NOT_DEL));
        if(null == procInstPO){
            throw new ZTBusinessException("该流程实例【"+flowProcInstDto.getProcInstId()+"】不为未完成状态，不可取消");
        }else{
            //更新流程实例为取消
            PublicProcInstPO updateProcInstPO = new PublicProcInstPO();
            updateProcInstPO.setDataId(procInstPO.getDataId());
            updateProcInstPO.setFinishTag(DycProCommonFlowConstant.FinishTag.FINISH_TAG_CANCEL);
            updateProcInstPO.setFinishTime(new Date());
            this.publicProcInstMapper.updateById(updateProcInstPO);

            //更新该流程实例下未完成的任务为取消
            PublicProcTaskInstPO updateTaskInstPO = new PublicProcTaskInstPO();
            updateTaskInstPO.setFinishTag(DycProCommonFlowConstant.FinishTag.FINISH_TAG_CANCEL);
            updateTaskInstPO.setFinishTime(new Date());
            updateTaskInstPO.setDealRemark("流程取消，自动取消");
            this.publicProcTaskInstMapper.update(updateTaskInstPO,Wrappers.<PublicProcTaskInstPO>lambdaQuery()
                    .eq(PublicProcTaskInstPO::getProcInstId,flowProcInstDto.getProcInstId())
                    .eq(PublicProcTaskInstPO::getFinishTag, DycProCommonFlowConstant.FinishTag.FINISH_TAG_NOT_FINISH)
                    .eq(PublicProcTaskInstPO::getDelFlag, DycProCommonFlowConstant.DelFlag.DEL_FLAG_NOT_DEL));
        }
    }

    @Override
    public DycProPublicProcInstDTO queryFlowMainInfo(DycProPublicProcInstDTO flowProcInstDto) {
        //参数校验
        this.queryFlowMainInfoParamVerify(flowProcInstDto);
        //数据查询
        PublicProcInstPO publicProcInstPO = this.publicProcInstMapper.selectOne(Wrappers.<PublicProcInstPO>lambdaQuery()
                .eq(null != flowProcInstDto.getDataId(), PublicProcInstPO::getDataId, flowProcInstDto.getDataId()));
        DycProPublicProcInstDTO rspDto = new DycProPublicProcInstDTO();
        BeanUtils.copyProperties(publicProcInstPO,rspDto);
        return rspDto;
    }

    /**
     * 查询流程单据主体信息（单条）参数校验
     */
    private void queryFlowMainInfoParamVerify(DycProPublicProcInstDTO flowProcInstDto){
        if(null == flowProcInstDto.getDataId()){
            throw new ZTBusinessException("流程单据ID[dataId]不能为空");
        }
    }

    /**
     * 流程终止参数校验
     * @param flowProcInstDto
     */
    private void cancelFlowParamVerify(DycProPublicProcInstDTO flowProcInstDto){
        if(StringUtils.isBlank(flowProcInstDto.getProcInstId())){
            throw new ZTBusinessException("流程实例ID不能为空");
        }
    }
}
