package com.tydic.dyc.pro.base.core.encode.service.bo;

import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 标题:SerialRuleDTO
 * 说明:TODO
 * 时间:2025/4/16 19:03
 * 作者:罗有
 */

@TableName("SERIAL_RULE")
@Data
public class DycProEncodeSerialRuleBO implements Serializable {

	private static final long serialVersionUID = 8239937292823060284L;

	/**
	 * 编码规则ID
	 */
	private Long encodeRuleId;
	/**
	 * 所属模块
	 */
	private String centerCode;
	/**
	 * 编码规则编码 唯一 格式:表名_字段名 ,同表同字段要区分业务则拼接“_业务类型枚举”
	 */
	private String encodeRuleCode;
	/**
	 * 编码规则名称
	 */
	private String encodeRuleName;
	/**
	 * 是否允许前台修改 1是 0否
	 */
	private Integer pageChangeFlag;
	/**
	 * 前缀
	 */
	private String prefix;
	/**
	 * 一级链接符
	 */
	private String firstConnectSymbol;
	/**
	 * 日期 格式:yyyyMMdd 支持java的日期转换格式
	 */
	private String dateInfix;
	/**
	 * 二级链接符
	 */
	private String secondConnectSymbol;
	/**
	 * 序列号位数
	 */
	private Long serialNum;
	/**
	 * 步长
	 */
	private Long stepRange;
	/**
	 * 规则顺序 格式:1-2-3-4-5 1:前缀 2:一级连接符 3:日期 4:二级连接符 5:序列号
	 */
	private String ruleOrder;
	/**
	 * 创建人ID
	 */
	private Long createUserId;
	/**
	 * 创建人名称
	 */
	private String createUserName;
	/**
	 * 创建人账号
	 */
	private String createUserAccount;
	/**
	 * 创建人机构ID
	 */
	private Long createOrgId;
	/**
	 * 创建人机构名称
	 */
	private String createOrgName;
	/**
	 * 创建人机构树路径
	 */
	private String createOrgPath;
	/**
	 * 创建人公司ID
	 */
	private Long createCompanyId;
	/**
	 * 创建人公司名称
	 */
	private String createCompanyName;
	/**
	 * 创建时间
	 */
	private Date createTime;
	/**
	 * 更新人ID
	 */
	private Long updateUserId;
	/**
	 * 更新人名称
	 */
	private String updateUserName;
	/**
	 * 更新人账号
	 */
	private String updateUserAccount;
	/**
	 * 更新人机构ID
	 */
	private Long updateOrgId;
	/**
	 * 更新人机构名称
	 */
	private String updateOrgName;
	/**
	 * 更新人机构树路径
	 */
	private String updateOrgPath;
	/**
	 * 更新人公司ID
	 */
	private Long updateCompanyId;
	/**
	 * 更新人公司名称
	 */
	private String updateCompanyName;
	/**
	 * 更新时间
	 */
	private Date updateTime;

}
