package com.tydic.dyc.pro.base.core.dictionary.enums;

/**
 * @author lihulin
 * @description 售后返回方式
 * @date 2025/05/14
 **/

public enum DmcCommSkuAfterSaleInfoReturnType implements DictionaryEnum {
    /**
     * 上门取件
     */
    SEVEN("DMC_COMM_SKU_AFTER_SALE_INFO_RETURN_TYPE", "1", "上门取件", "售后返回方式"),
    /**
     * 客户寄回
     */
    FIFTEEN("DMC_COMM_SKU_AFTER_SALE_INFO_RETURN_TYPE", "2", "客户寄回", "售后返回方式"),
    /**
     * 上门取件+客户寄回
     */
    TWENTY("DMC_COMM_SKU_AFTER_SALE_INFO_RETURN_TYPE", "3", "上门取件+客户寄回", "售后返回方式");
    /**
     * 编码
     */
    private String dictionaryCode;
    /**
     * 编码
     */
    private String code;
    /**
     * 编码值
     */
    private String value;
    /**
     * 名称
     */
    private String dictionaryName;

    DmcCommSkuAfterSaleInfoReturnType(String dictionaryCode, String code, String value, String dictionaryName) {
        this.dictionaryCode = dictionaryCode;
        this.code = code;
        this.value = value;
        this.dictionaryName = dictionaryName;
    }

    public String getDictionaryCode() {
        return dictionaryCode;
    }

    public String getDictionaryName() {
        return dictionaryName;
    }

    public String getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}
