package com.tydic.dyc.pro.base.core.dictionary.enums;
/**
 * @description 对账状态 0未对账 1对账一致 2对账不一致
 * @author Luokan
 * @date 2025/04/16
 **/
public enum FscFscOrderCheckState implements DictionaryEnum{
    /**
     * 未对账
     */
    UN_CHECK("FSC_ORDER_CHECK_STATE","0","未对账", "对账状态"),
    /**
     * 对账一致
     */
    SAME_CHECK("FSC_ORDER_CHECK_STATE","1","对账一致", "对账状态"),
    /**
     * 对账不一致
     */
    UNSAME_CHECK("FSC_ORDER_CHECK_STATE","2","对账不一致", "对账状态");
    /**
     * 编码
     */
    private String dictionaryCode;
    /**
     * 编码
     */
    private String code;
    /**
     * 编码值
     */
    private String value;
    /**
     * 名称
     */
    private String dictionaryName;

    FscFscOrderCheckState(String dictionaryCode, String code, String value, String dictionaryName) {
        this.dictionaryCode = dictionaryCode;
        this.code = code;
        this.value = value;
        this.dictionaryName = dictionaryName;
    }
    public String getDictionaryCode() {
        return dictionaryCode;
    }

    public String getDictionaryName() {
        return dictionaryName;
    }

    public String getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}
