package com.tydic.dyc.pro.base.core.dictionary.enums;
/**
 * @description 服务费状态:
 *      * 1申请审批中，
 *      * 2申请审批驳回，
 *      * 3待供应商确认，
 *      * 4异议处理中，
 *      * 5减免审批中，
 *      * 6减免审批驳回，
 *      * 7已完成
 * @author Luokan
 * @date 2025/04/16
 **/
public enum EgcServFeeOrderState implements DictionaryEnum{
    /**
     /**
     * 1申请审批中
     */
    PENDING_APPROVING("SERV_FEE_STATE","1","申请审批中", "服务费状态"),
    /**
     /**
     * 2申请审批驳回
     */
    PENDING_APPROVE_BACK("SERV_FEE_STATE","2","申请审批驳回", "服务费状态"),
    /**
     /**
     * 3待供应商确认
     */
    SUP_CONFIRM("SERV_FEE_STATE","3","待供应商确认", "服务费状态"),
    /**
     /**
     * 4异议处理中
     */
    DEAL_OBJECTION("SERV_FEE_STATE","4","异议处理中", "服务费状态"),
    /**
     /**
     * 5减免审批中
     */
    REDUCE_APPROVING("SERV_FEE_STATE","5","减免审批中", "服务费状态"),
    /**
     /**
     * 6减免审批驳回
     */
    REDUCE_APPROVE_BACK("SERV_FEE_STATE","6","减免审批驳回", "服务费状态"),
    /**
     /**
     * 7已完成
     */
    FINISH("SERV_FEE_STATE","7","已完成", "服务费状态");
    /**
     * 编码
     */
    private String dictionaryCode;
    /**
     * 编码
     */
    private String code;
    /**
     * 编码值
     */
    private String value;
    /**
     * 名称
     */
    private String dictionaryName;

    EgcServFeeOrderState(String dictionaryCode, String code, String value, String dictionaryName) {
        this.dictionaryCode = dictionaryCode;
        this.code = code;
        this.value = value;
        this.dictionaryName = dictionaryName;
    }
    public String getDictionaryCode() {
        return dictionaryCode;
    }

    public String getDictionaryName() {
        return dictionaryName;
    }

    public String getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}
