package com.tydic.dyc.pro.base.core.contentreview.impl;

import com.aliyun.imageaudit20191230.Client;
import com.aliyun.imageaudit20191230.models.ScanTextRequest;
import com.aliyun.imageaudit20191230.models.ScanTextResponse;
import com.aliyun.imageaudit20191230.models.ScanTextResponseBody;
import com.aliyun.imageaudit20191230.models.ScanTextResponseBody.ScanTextResponseBodyDataElementsResultsDetailsContexts;
import com.aliyun.teautil.models.RuntimeOptions;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.base.core.contentreview.api.DycProContentReviewAliyunTextScanService;
import com.tydic.dyc.pro.base.core.contentreview.bo.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
/**
 * @Author HeDengHui
 * @Date 2025/5/30 12.51
 * @Description:文字审核接口实现
 **/
@Service
@Slf4j
public class DycProContentReviewAliyunTextScanServiceImpl implements DycProContentReviewAliyunTextScanService {
    @Autowired
    private Client aliyunClient;

    @Override
    public DycProContentReviewTextScanRspBO textScan(DycProContentReviewTextScanReqBO reqBO) {
        //参数校验
        this.textScanParamVerify(reqBO);
        // 构造sdk请求
        ScanTextRequest scanTextRequest = this.getTextScanRequest(reqBO);
        RuntimeOptions runtimeOptions = new RuntimeOptions();
        ScanTextResponse scanTextResponse;
        try {
            Date start = new Date();
            // 调用阿里云内容审核服务
            scanTextResponse = aliyunClient.scanTextWithOptions(scanTextRequest, runtimeOptions);
            Date end = new Date();
            log.info("文字检测总耗时：" + (end.getTime() - start.getTime()));

        } catch (Exception e) {
            log.error("阿里云API调用文字监测失败：" + e.getMessage());
            throw new ZTBusinessException("阿里云调用文字监测失败" + e.getMessage());
        }

        // 将解析结果进行返回
        DycProContentReviewTextScanRspBO resultsBO = new DycProContentReviewTextScanRspBO();
        if (scanTextResponse != null && 200 == scanTextResponse.statusCode && scanTextResponse.getBody() != null) {
            log.info("图片检测requestId：" + scanTextResponse.getBody().getRequestId());
            // 设置请求ID
            resultsBO.setRequestId(scanTextResponse.getBody().getRequestId());
            // 返回结果解析层次，element
            if (scanTextResponse.getBody().getData() != null && scanTextResponse.getBody().getData().getElements() != null) {
                // 获取原始内容列表，用于关联
                List<String> originalContents = reqBO.getContent();
                // 创建一个总的结果列表
                List<DycProContentReviewTextScanSubResultBO> allResults = new ArrayList<>();

                for (int i = 0; i < scanTextResponse.getBody().getData().getElements().size(); i++) {
                    ScanTextResponseBody.ScanTextResponseBodyDataElements element =
                            scanTextResponse.getBody().getData().getElements().get(i);

                    // 获取对应的原始内容
                    String originalContent = i < originalContents.size() ? originalContents.get(i) : "";
                            // 处理results
                            List<DycProContentReviewTextScanSubResultBO> resultsList = null;
                            if (element.getResults() != null) {
                                resultsList = element.getResults().stream()
                                        .map(result -> {
                                            DycProContentReviewTextScanSubResultBO resultBO = new DycProContentReviewTextScanSubResultBO();
                                            resultBO.setSuggestion(result.getSuggestion());
                                            resultBO.setLabel(result.getLabel());
                                            resultBO.setRate(result.getRate());
                                            // 设置送检内容
                                            resultBO.setContent(originalContent);
                                            // 设置不符合规范字段
                                            List<String> contextList = null;
                                            if (result.getDetails() != null) {
                                                contextList = result.getDetails().stream()
                                                        .filter(detail -> detail.getContexts() != null)
                                                        .flatMap(detail -> detail.getContexts().stream())
                                                        .map(ScanTextResponseBodyDataElementsResultsDetailsContexts::getContext)
                                                        .collect(Collectors.toList());
                                            } else {
                                                contextList = new ArrayList<>();
                                            }
                                            resultBO.setContexts(contextList);
                                            return resultBO;
                                        })
                                        .collect(Collectors.toList());
                            }else {
                                resultsList = new ArrayList<>();
                            }
                            // 将当前元素的结果添加到总结果列表中
                        allResults.addAll(resultsList);
                        }
                resultsBO.setResults(allResults);
            }else {
                log.info("文字检测返回数据为空");
                resultsBO.setResults(new ArrayList<>());
            }

        } else {
            log.info("文字检测失败，无内容");
            return null;
        }

        return resultsBO;
    }

    /**
     * 参数校验
     * @param reqBO
     */
    private void textScanParamVerify(DycProContentReviewTextScanReqBO reqBO){
        if(null == reqBO){
            throw new ZTBusinessException("请求对象不能为空");
        }
        if(CollectionUtils.isEmpty(reqBO.getContent())){
            throw new ZTBusinessException("检查内容不能为空");
        }
        if(CollectionUtils.isEmpty(reqBO.getLabels())){
            throw new ZTBusinessException("检查指标项不能为空");
        }
    }


    /**
     * 获取传输阿里云的封装对象
     */
    private ScanTextRequest getTextScanRequest(DycProContentReviewTextScanReqBO reqBO) {

        // 构建阿里sdk对象
        ScanTextRequest scanTextRequest = new ScanTextRequest();
        List<ScanTextRequest.ScanTextRequestTasks> sdkTasks = new ArrayList<>();
        sdkTasks = reqBO.getContent().stream()
                    .map(t -> new ScanTextRequest.ScanTextRequestTasks()
                            .setContent(t))
                    .collect(Collectors.toList());

        List<ScanTextRequest.ScanTextRequestLabels> sdkLabels = new ArrayList<>();
            sdkLabels = reqBO.getLabels().stream()
                    .map(l -> new ScanTextRequest.ScanTextRequestLabels()
                            .setLabel(l))
                    .collect(Collectors.toList());
       // sdk对象返回
        scanTextRequest.setTasks(sdkTasks);
        scanTextRequest.setLabels(sdkLabels);
        return scanTextRequest;
    }

}
