package com.tydic.dyc.pro.base.core.dictionary.enums;

public enum DmcCommOperateRecordActionTypeEnum implements DictionaryEnum{
    ADD("DMC_COMM_OPERATE_RECORD_ACTION_TYPE", "1", "新增", "动作类型"),
    UPDATE("DMC_COMM_OPERATE_RECORD_ACTION_TYPE", "2", "编辑", "动作类型"),
    DELETE("DMC_COMM_OPERATE_RECORD_ACTION_TYPE", "3", "删除", "动作类型"),
    ENABLE("DMC_COMM_OPERATE_RECORD_ACTION_TYPE", "4", "启用", "动作类型"),
    DISABLE("DMC_COMM_OPERATE_RECORD_ACTION_TYPE", "5", "停用", "动作类型"),
    ON_SHELVE("DMC_COMM_OPERATE_RECORD_ACTION_TYPE", "6", "上架了商品", "动作类型"),
    MANDATORY_SHELVE("DMC_COMM_OPERATE_RECORD_ACTION_TYPE", "7", "强制上架了商品", "动作类型"),
    DOWN_SHELVE("DMC_COMM_OPERATE_RECORD_ACTION_TYPE", "8", "下架了商品", "动作类型"),
    SUBMIT_SKU("DMC_COMM_OPERATE_RECORD_ACTION_TYPE", "9", "提交了商品", "动作类型"),
    ;
    /**
     * 编码
     */
    private String dictionaryCode;
    /**
     * 编码
     */
    private String code;
    /**
     * 编码值
     */
    private String value;
    /**
     * 名称
     */
    private String dictionaryName;
    DmcCommOperateRecordActionTypeEnum(String dictionaryCode, String code, String value, String dictionaryName) {
        this.dictionaryCode = dictionaryCode;
        this.code = code;
        this.value = value;
        this.dictionaryName = dictionaryName;
    }
    @Override
    public String getDictionaryCode() {
        return dictionaryCode;
    }

    @Override
    public String getDictionaryName() {
        return dictionaryName;
    }

    @Override
    public String getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}
