package com.tydic.dyc.pro.base.core.dictionary.enums;

/**
 * @description 库存变化类型 1总库存增加2总库存减少 3扣减4回退库存
 * @author Luokan
 * @date 2025/04/23
 **/

public enum DmcCommSkuStockInfoRecordsChangeType implements DictionaryEnum{
    /**
     * 1总库存增加
     */
    TOTAL_ADD("CHANGE_TYPE", "1","总库存增加", "库存变化类型"),
    /**
     * 2总库存减少
     */
    TOTAL_REDUCE("CHANGE_TYPE", "2","总库存减少", "库存变化类型"),
    /**
     * 3扣减
     */
    ORDER_REDUCE("CHANGE_TYPE", "3","扣减", "库存变化类型"),
    /**
     * 4回退库存
     */
    ORDER_BACK("CHANGE_TYPE", "4","回退库存", "库存变化类型");
    /**
     * 编码
     */
    private String dictionaryCode;
    /**
     * 编码
     */
    private String code;
    /**
     * 编码值
     */
    private String value;
    /**
     * 名称
     */
    private String dictionaryName;

    DmcCommSkuStockInfoRecordsChangeType(String dictionaryCode,String code, String value, String dictionaryName) {
        this.dictionaryCode = dictionaryCode;
        this.code = code;
        this.value = value;
        this.dictionaryName = dictionaryName;
    }
    public String getDictionaryCode() {
        return dictionaryCode;
    }

    public String getDictionaryName() {
        return dictionaryName;
    }

    public String getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}
