package com.tydic.dyc.pro.base.core.dictionary.enums;

/**
 * 协议质保周期单位 枚举
 *
 * @author lihulin
 */

public enum DmcAgrMainQuaprotectUnit implements DictionaryEnum {
    DAY("DMC_AGR_MAIN_QUAPROTECT_UNIT", "0", "天", "协议质保周期单位"),
    MOUNTH("DMC_AGR_MAIN_QUAPROTECT_UNIT", "1", "月", "协议质保周期单位"),
    YEAR("DMC_AGR_MAIN_QUAPROTECT_UNIT", "2", "年", "协议质保周期单位");
    /**
     * 编码
     */
    private String dictionaryCode;
    /**
     * 编码
     */
    private String code;
    /**
     * 编码值
     */
    private String value;
    /**
     * 名称
     */
    private String dictionaryName;

    DmcAgrMainQuaprotectUnit(String dictionaryCode, String code, String value, String dictionaryName) {
        this.dictionaryCode = dictionaryCode;
        this.code = code;
        this.value = value;
        this.dictionaryName = dictionaryName;
    }

    public String getDictionaryCode() {
        return dictionaryCode;
    }

    public String getDictionaryName() {
        return dictionaryName;
    }

    public String getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}
