package com.tydic.dyc.pro.base.core.dictionary.enums;

/**
 * 标题：DmcCommManageCatalogInfoPurchaseType
 * 说明：所属品类
 * 时间：2025/11/11 17:01
 *
 * @author lihulin
 **/
public enum DmcCommManageCatalogInfoPurchaseType implements DictionaryEnum {
    BGL("PURCHASE_TYPE", "1", "办公用品", "采购类型"),
    MOR("PURCHASE_TYPE", "2", "MRO工业品", "采购类型"),
    GC("PURCHASE_TYPE", "3", "劳保用品", "采购类型"),
    SYSB("PURCHASE_TYPE", "4", "通用电子设备", "采购类型");

    /**
     * 编码
     */
    private String dictionaryCode;
    /**
     * 编码
     */
    private String code;
    /**
     * 编码值
     */
    private String value;
    /**
     * 名称
     */
    private String dictionaryName;

    DmcCommManageCatalogInfoPurchaseType(String dictionaryCode, String code, String value, String dictionaryName) {
        this.dictionaryCode = dictionaryCode;
        this.code = code;
        this.value = value;
        this.dictionaryName = dictionaryName;
    }

    public String getDictionaryCode() {
        return dictionaryCode;
    }

    public String getDictionaryName() {
        return dictionaryName;
    }

    public String getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}
