package com.tydic.dyc.pro.base.bo.esmapping;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 标题：DycProEsIndexMappingAfOrderBO
 * 描述：售后单索引映射
 */
@Data
public class DycProEsIndexMappingAfOrderBO implements Serializable {

    private static final long serialVersionUID = 73609422458557841L;

    /**
     * 售后服务单id
     */
    private Long afOrderId;

    /**
     * 售后服务单编码
     */
    private String afServCode;

    /**
     * 订单id
     */
    private Long orderId;

    /**
     * 销售单id
     */
    private Long saleOrderId;

    /**
     * 外部售后服务单号
     */
    private String extAfId;

    /**
     * 服务类型 退货(10)、换货(20)、维修(30)
     */
    private Integer servType;

    /**
     * 取货服务类型 4： 上门取件 40：客户发货 7： 客户送货
     */
    private Integer pickwareType;

    /**
     * 服务单状态 100提交申请 200 审核中 201审核不通过 300收货完成 400退款成功 401退款失败 500 已完成 600 取消
     */
    private Integer servState;

    /**
     * 实际退款金额
     */
    private BigDecimal realReturnFee;

    /**
     * 服务提出人名称
     */
    private String submitterOperName;

    /**
     * 销售退款总金额
     */
    private BigDecimal retTotalSaleFee;

    /**
     * 采购退款总金额
     */
    private BigDecimal retTotalPurchaseFee;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 供应商确认时间
     */
    private Date confirmTime;

    /**
     * 完成时间
     */
    private Date finishTime;

    /**
     * 售后总数量
     */
    private BigDecimal totalReturnCount;

    /**
     * 是否可维护发运信息 1是 0否
     */
    private Integer waybillFlag;

    /**
     * 订单来源
     */
    private Integer orderSource;

    /**
     * 销售单编码
     */
    private String saleOrderNo;

    /**
     * 外部销售单编码
     */
    private String saleOrderNoExt;

    /**
     * 结算模式 2:撮合 1:贸易
     */
    private Integer modelSettle;

    /**
     * 下单人名称
     */
    private String orderCreateOperName;

    /**
     * 销售单三方信息
     */
    private DycProEsIndexMappingSaleStakeholderBO saleStakeholder;

    /**
     * 售后单明细
     */
    private List<DycProEsIndexMappingAfOrderItemBO> afItemList;

}
