package com.tydic.dyc.pro.base.bo.esmapping;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 标题：DycProEsIndexMappingShipOrderBO
 * 描述：发货单索引映射
 */
@Data
public class DycProEsIndexMappingShipOrderBO implements Serializable {

    private static final long serialVersionUID = -4906412368224353537L;

    /**
     * 发货单id
     */
    private Long shipOrderId;

    /**
     * 销售单id
     */
    private Long saleOrderId;

    /**
     * 订单id
     */
    private Long orderId;

    /**
     * 发货单编码
     */
    private String shipOrderNo;

    /**
     * 外部发货单编码
     */
    private String shipOrderNoExt;

    /**
     * 发货单状态
     */
    private String shipOrderState;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 销售单编码
     */
    private String saleOrderNo;

    /**
     * 订单来源
     */
    private Integer orderSource;

    /**
     * 下单时间
     */
    private Date orderCreateTime;

    /**
     * 下单人名称
     */
    private String orderCreateOperName;

    /**
     * 外部销售单编码
     */
    private String saleOrderNoExt;
    /**
     *发货时间
     */
    private Date shipTime;
    /**
     *预计到货时间
     */
    private Date estimateArrivalTime;
    /**
     *到货时间
     */
    private Date arriveTime;
    /**
     *发货联系人姓名
     */
    private String shipName;
    /**
     *发货联系人电话
     */
    private String shipPhone;
    /**
     *物流公司id
     */
    private String shipCompanyId;
    /**
     *物流公司名称
     */
    private String shipCompanyName;
    /**
     *物流单号
     */
    private String shipCompanyNo;

    /**
     * 销售单三方信息
     */
    private DycProEsIndexMappingSaleStakeholderBO saleStakeholder;

    /**
     * 发货单明细
     */
    private List<DycProEsIndexMappingShipOrderItemBO> shipItemList;
    /**
     *收/拒收 货人
     */
    private String receiverUser;
    /**
     *收/拒收 货备注
     */
    private String receiverRemark;
    /**
     *收/拒收 联系人
     */
    private String receiverContact;
    /**
     *收/拒收 时间
     */
    private Date receiverTime;

}
