package com.tydic.dyc.pro.base.core.dictionary.enums;

/**
 * 协议模式 枚举
 *
 * @author lihulin
 */

public enum DmcAgrMainAgrMode implements DictionaryEnum {
    PTXY("DMC_AGR_MAIN_AGR_MODE", "1", "平台协议", "协议模式"),
    DSXY("DMC_AGR_MAIN_AGR_MODE", "2", "单位协议", "协议模式");
    /**
     * 编码
     */
    private String dictionaryCode;
    /**
     * 编码
     */
    private String code;
    /**
     * 编码值
     */
    private String value;
    /**
     * 名称
     */
    private String dictionaryName;

    DmcAgrMainAgrMode(String dictionaryCode, String code, String value, String dictionaryName) {
        this.dictionaryCode = dictionaryCode;
        this.code = code;
        this.value = value;
        this.dictionaryName = dictionaryName;
    }

    public String getDictionaryCode() {
        return dictionaryCode;
    }

    public String getDictionaryName() {
        return dictionaryName;
    }

    public String getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}
