package com.tydic.dyc.pro.base.core.dictionary.enums;

/**
 * @Author：zyy
 * 禁售类型 1.禁售规则 2.价格检测 3.图文检测 4.电商下架 5.协议冻结 6.协议过期 7.协议补充 8.协议暂停 9.协议调价
 * @Date：2025/5/16 9:49
 */
public enum DmcCommBansRecordBansTypeEnum implements DictionaryEnum{

    BANS_RULE("BANS_TYPE", "1", "禁售规则", "禁售类型"),
    PRICE_CHECK("BANS_TYPE", "2", "价格检测", "禁售类型"),
    IMAGE_CHECK("BANS_TYPE", "3", "图文检测", "禁售类型"),
    ECOMM_DOWN("BANS_TYPE", "4", "电商下架", "禁售类型"),
    AGR_FREEZE("BANS_TYPE", "5", "协议冻结", "禁售类型"),
    AGR_EXP("BANS_TYPE", "11", "协议过期", "禁售类型"),
    AGR_SUPPLEMENT("BANS_TYPE", "12", "协议补充", "禁售类型"),
    AGR_PAUSE("BANS_TYPE", "13", "协议暂停", "禁售类型"),
    AGR_ADJUST_PRICE("BANS_TYPE", "14", "协议调价", "禁售类型"),
    AGR_TERMINATE("BANS_TYPE", "15", "协议终止", "禁售类型");
    /**
     * 编码
     */
    private String dictionaryCode;
    /**
     * 编码
     */
    private String code;
    /**
     * 编码值
     */
    private String value;
    /**
     * 名称
     */
    private String dictionaryName;
    DmcCommBansRecordBansTypeEnum(String dictionaryCode, String code, String value, String dictionaryName) {
        this.dictionaryCode = dictionaryCode;
        this.code = code;
        this.value = value;
        this.dictionaryName = dictionaryName;
    }
    @Override
    public String getDictionaryCode() {
        return dictionaryCode;
    }

    @Override
    public String getDictionaryName() {
        return dictionaryName;
    }

    @Override
    public String getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}
