package com.tydic.dyc.pro.base.core.dictionary.enums;

/**
 * 频道关联方式枚举
 * @author 19332
 */

public enum DmcCommChannelInfoRelatedType implements DictionaryEnum {
    MANAGEMENT("DMC_COMM_CHANNEL_INFO_RELATED_TYPE", "1", "后台管理类目", "频道关联方式"),
    POOL("DMC_COMM_CHANNEL_INFO_RELATED_TYPE", "2", "商品池", "频道关联方式");
    /**
     * 编码
     */
    private String dictionaryCode;
    /**
     * 编码
     */
    private String code;
    /**
     * 编码值
     */
    private String value;
    /**
     * 名称
     */
    private String dictionaryName;

    DmcCommChannelInfoRelatedType(String dictionaryCode, String code, String value, String dictionaryName) {
        this.dictionaryCode = dictionaryCode;
        this.code = code;
        this.value = value;
        this.dictionaryName = dictionaryName;
    }
    public String getDictionaryCode() {
        return dictionaryCode;
    }

    public String getDictionaryName() {
        return dictionaryName;
    }

    public String getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}
