package com.tydic.dyc.pro.base.core.dictionary.enums;

/**
 * 标题：DmcSscSupplyApplyInfoPurchaseForm
 * 描述：寻源-供货申请-采购形式
 */
public enum DmcSscAuditDealResult implements DictionaryEnum {

    PASS("DMC_SSC_AUDIT_DEAL_RESULT", "pass", "审批通过", "审批处理结果"),
    REJECT("DMC_SSC_AUDIT_DEAL_RESULT", "reject", "审批驳回", "审批处理结果"),
    TRANSF("DMC_SSC_AUDIT_DEAL_RESULT", "transf", "转交", "审批处理结果");

    /**
     * 编码
     */
    private String dictionaryCode;
    /**
     * 编码
     */
    private String code;
    /**
     * 编码值
     */
    private String value;
    /**
     * 名称
     */
    private String dictionaryName;

    DmcSscAuditDealResult(String dictionaryCode, String code, String value, String dictionaryName) {
        this.dictionaryCode = dictionaryCode;
        this.code = code;
        this.value = value;
        this.dictionaryName = dictionaryName;
    }

    public String getDictionaryCode() {
        return dictionaryCode;
    }

    public String getDictionaryName() {
        return dictionaryName;
    }

    public String getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}
