package com.tydic.dyc.pro.base.core.dictionary.enums;

/**
 * 标题：DmcSscConsultAllowMissingItems
 * 描述：协商单-是否允许缺项报价
 */
public enum DmcSscConsultAllowMissingItems implements DictionaryEnum {

    NO ("DMC_SSC_CONSULT_ALLOW_MISSING_ITEMS", "0", "否", "是否允许缺项报价"),
    YES ("DMC_SSC_CONSULT_ALLOW_MISSING_ITEMS", "1", "是", "是否允许缺项报价");

    /**
     * 编码
     */
    private String dictionaryCode;
    /**
     * 编码
     */
    private String code;
    /**
     * 编码值
     */
    private String value;
    /**
     * 名称
     */
    private String dictionaryName;

    DmcSscConsultAllowMissingItems(String dictionaryCode, String code, String value, String dictionaryName) {
        this.dictionaryCode = dictionaryCode;
        this.code = code;
        this.value = value;
        this.dictionaryName = dictionaryName;
    }

    public String getDictionaryCode() {
        return dictionaryCode;
    }

    public String getDictionaryName() {
        return dictionaryName;
    }

    public String getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}
