package com.tydic.dyc.pro.base.core.dictionary.enums;

/**
 * 标题：DmcSscSupplyApplyInfoStatus
 * 描述：寻源-供货申请-状态
 */
public enum DmcSscSupplyApplyInfoStatus implements DictionaryEnum {

    DRAFT ("DMC_SSC_SUPPLY_APPLY_INFO_STATUS", "1", "草稿", "供货申请状态"),
    IN_APPROVAL("DMC_SSC_SUPPLY_APPLY_INFO_STATUS", "2", "审批中", "供货申请状态"),
    PASS_APPROVAL("DMC_SSC_SUPPLY_APPLY_INFO_STATUS", "3", "审批通过", "供货申请状态"),
    REJECT_APPROVAL("DMC_SSC_SUPPLY_APPLY_INFO_STATUS", "4", "审批驳回", "供货申请状态");

    /**
     * 编码
     */
    private String dictionaryCode;
    /**
     * 编码
     */
    private String code;
    /**
     * 编码值
     */
    private String value;
    /**
     * 名称
     */
    private String dictionaryName;

    DmcSscSupplyApplyInfoStatus(String dictionaryCode, String code, String value, String dictionaryName) {
        this.dictionaryCode = dictionaryCode;
        this.code = code;
        this.value = value;
        this.dictionaryName = dictionaryName;
    }

    public String getDictionaryCode() {
        return dictionaryCode;
    }

    public String getDictionaryName() {
        return dictionaryName;
    }

    public String getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}
